/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.impl;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.AttributeImpl;
import org.hibernate.search.indexes.serialization.spi.SerializableTokenStream;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class CopyTokenStream
extends TokenStream
implements Serializable {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private List<List<AttributeImpl>> cache;
    private int index = 0;

    public static SerializableTokenStream buildSerializableTokenStream(TokenStream tokenStream) {
        try {
            List<List<AttributeImpl>> stream = CopyTokenStream.createAttributeLists(tokenStream);
            return new SerializableTokenStream(stream);
        }
        catch (IOException e) {
            throw log.unableToReadTokenStream();
        }
    }

    public CopyTokenStream(List<List<AttributeImpl>> stream) {
        this.cache = stream;
    }

    public final boolean incrementToken() throws IOException {
        if (this.index >= this.cache.size()) {
            return false;
        }
        this.setState(this.index);
        ++this.index;
        return true;
    }

    private void setState(int localIndex) {
        for (AttributeImpl attr : this.cache.get(localIndex)) {
            this.addAttributeImpl(attr);
        }
    }

    public final void end() throws IOException {
        if (this.cache.size() > 0) {
            this.setState(this.cache.size() - 1);
        }
    }

    public void reset() throws IOException {
        this.index = 0;
    }

    private static List<List<AttributeImpl>> createAttributeLists(TokenStream input) throws IOException {
        ArrayList<List<AttributeImpl>> results = new ArrayList<List<AttributeImpl>>();
        input.reset();
        while (input.incrementToken()) {
            ArrayList<AttributeImpl> attrs = new ArrayList<AttributeImpl>();
            results.add(attrs);
            Iterator iter = input.getAttributeImplsIterator();
            while (iter.hasNext()) {
                attrs.add(((AttributeImpl)iter.next()).clone());
            }
        }
        input.end();
        return results;
    }
}

