/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.conflict;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.EntryMergePolicyFactory;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class EntryMergePolicyFactoryRegistry {
    private static final Log log = LogFactory.getLog(EntryMergePolicyFactoryRegistry.class);
    private final List<EntryMergePolicyFactory> factories = Collections.synchronizedList(new ArrayList());

    public EntryMergePolicyFactoryRegistry() {
        this.factories.add(new EntryMergePolicyFactory(){

            @Override
            public <T> T createInstance(PartitionHandlingConfiguration config) {
                return (T)config.mergePolicy();
            }
        });
    }

    public EntryMergePolicy createInstance(PartitionHandlingConfiguration config) {
        for (EntryMergePolicyFactory factory : this.factories) {
            Object instance = factory.createInstance(config);
            if (instance == null) continue;
            return (EntryMergePolicy)instance;
        }
        return null;
    }

    public void addMergePolicyFactory(EntryMergePolicyFactory factory) {
        if (factory == null) {
            throw log.unableToAddNullEntryMergePolicyFactory();
        }
        this.factories.add(0, factory);
    }
}

