/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;

@MBean
@Scope(value=Scopes.GLOBAL)
public abstract class ManageableExecutorService<T extends ExecutorService> {
    protected volatile T executor;

    @ManagedAttribute(description="Returns the number of threads in this executor.", displayName="Number of executor threads", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public int getPoolSize() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getPoolSize();
        }
        return -1;
    }

    @ManagedAttribute(description="Returns the number of active executor threads.", displayName="Number of active executor threads", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public int getActiveCount() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getActiveCount();
        }
        return -1;
    }

    @ManagedAttribute(description="Returns the maximum number of executor threads.", displayName="Maximum number of executor threads", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY, writable=true)
    public int getMaximumPoolSize() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getMaximumPoolSize();
        }
        return -1;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        if (this.executor instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.executor).setMaximumPoolSize(maximumPoolSize);
            if (!(((ThreadPoolExecutor)this.executor).getQueue() instanceof SynchronousQueue)) {
                ((ThreadPoolExecutor)this.executor).setCorePoolSize(maximumPoolSize);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @ManagedAttribute(description="Returns the largest ever number of executor threads.", displayName="Largest number of executor threads", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public int getLargestPoolSize() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getLargestPoolSize();
        }
        return -1;
    }

    @ManagedAttribute(description="Returns the number of elements in this executor's queue.", displayName="Elements in the queue", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public int getQueueSize() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getQueue().size();
        }
        return -1;
    }

    @ManagedAttribute(description="Returns the keep-alive time for this pool's threads", displayName="Keep-alive for pooled threads", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public long getKeepAliveTime() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getKeepAliveTime(TimeUnit.MILLISECONDS);
        }
        return -1L;
    }

    public void setKeepAliveTime(long milliseconds) {
        if (!(this.executor instanceof ThreadPoolExecutor)) {
            throw new UnsupportedOperationException();
        }
        ((ThreadPoolExecutor)this.executor).setKeepAliveTime(milliseconds, TimeUnit.MILLISECONDS);
    }
}

