/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.notifications.cachelistener.cluster.ClusterCacheNotifier;
import org.infinispan.notifications.cachelistener.cluster.ClusterEvent;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MultiClusterEventCallable<K, V>
implements DistributedCallable<K, V, Void> {
    private static final Log log = LogFactory.getLog(MultiClusterEventCallable.class);
    private static final boolean trace = log.isTraceEnabled();
    private transient ClusterCacheNotifier<K, V> clusterCacheNotifier;
    private final Map<UUID, Collection<ClusterEvent<K, V>>> multiEvents;

    public MultiClusterEventCallable(Map<UUID, Collection<ClusterEvent<K, V>>> events) {
        this.multiEvents = events;
    }

    @Override
    public Void call() throws Exception {
        if (trace) {
            log.tracef("Received multiple cluster event(s) %s", this.multiEvents);
        }
        for (Map.Entry<UUID, Collection<ClusterEvent<K, V>>> entry : this.multiEvents.entrySet()) {
            UUID identifier = entry.getKey();
            Collection<ClusterEvent<K, V>> events = entry.getValue();
            this.clusterCacheNotifier.notifyClusterListeners(events, identifier);
        }
        return null;
    }

    @Override
    public void setEnvironment(Cache<K, V> cache, Set<K> inputKeys) {
        this.clusterCacheNotifier = cache.getAdvancedCache().getComponentRegistry().getComponent(ClusterCacheNotifier.class);
        for (Collection<ClusterEvent<K, V>> events : this.multiEvents.values()) {
            for (ClusterEvent<K, V> event : events) {
                event.cache = cache;
            }
        }
    }

    public static class Externalizer
    extends AbstractExternalizer<MultiClusterEventCallable> {
        public Set<Class<? extends MultiClusterEventCallable>> getTypeClasses() {
            return Collections.singleton(MultiClusterEventCallable.class);
        }

        public void writeObject(ObjectOutput output, MultiClusterEventCallable object) throws IOException {
            output.writeObject(object.multiEvents);
        }

        public MultiClusterEventCallable readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new MultiClusterEventCallable((Map)input.readObject());
        }

        public Integer getId() {
            return 82;
        }
    }
}

