/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.AbstractConfigSource;
import java.util.Collections;
import java.util.Map;

public abstract class MapBackedConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = -7159956218217228877L;
    private final Map<String, String> properties;

    public MapBackedConfigSource(String name, Map<String, String> propertyMap) {
        super(name, Integer.parseInt(propertyMap.getOrDefault("config_ordinal", "100")));
        this.properties = propertyMap;
    }

    public MapBackedConfigSource(String name, Map<String, String> propertyMap, int defaultOrdinal) {
        super(name, Integer.parseInt(propertyMap.getOrDefault("config_ordinal", String.valueOf(defaultOrdinal))));
        this.properties = propertyMap;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String getValue(String propertyName) {
        return this.properties.get(propertyName);
    }
}

