/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow;

import io.undertow.servlet.api.Deployment;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.logging.Logger;
import org.jboss.modcluster.container.Connector;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Server;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.mod_cluster.undertow.LocationContext;
import org.wildfly.mod_cluster.undertow.UndertowConnector;
import org.wildfly.mod_cluster.undertow.UndertowContext;
import org.wildfly.mod_cluster.undertow.UndertowEngine;
import org.wildfly.mod_cluster.undertow.UndertowEventHandlerAdapterConfiguration;
import org.wildfly.mod_cluster.undertow.UndertowHost;
import org.wildfly.mod_cluster.undertow.UndertowServer;

public class UndertowEventHandlerAdapterService
implements UndertowEventListener,
Service,
Runnable,
ServerActivity {
    private static final Logger log = Logger.getLogger((String)"org.jboss.mod_cluster.undertow");
    private final UndertowEventHandlerAdapterConfiguration configuration;
    private final Set<Context> contexts = new HashSet<Context>();
    private volatile ScheduledExecutorService executor;
    private volatile Server server;
    private volatile Connector connector;
    private volatile String serverName;

    public UndertowEventHandlerAdapterService(UndertowEventHandlerAdapterConfiguration configuration) {
        this.configuration = configuration;
    }

    public void start(StartContext context) {
        UndertowService service = this.configuration.getUndertowService();
        ContainerEventHandler eventHandler = this.configuration.getContainerEventHandler();
        this.connector = new UndertowConnector(this.configuration.getListener());
        this.serverName = this.configuration.getServer().getName();
        this.server = new UndertowServer(this.serverName, service, this.connector);
        service.registerListener((UndertowEventListener)this);
        eventHandler.init(this.server);
        eventHandler.start(this.server);
        this.executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new DefaultThreadFactory(UndertowEventHandlerAdapterService.class));
        this.executor.scheduleWithFixedDelay(this, 0L, this.configuration.getStatusInterval().toMillis(), TimeUnit.MILLISECONDS);
        this.configuration.getSuspendController().registerActivity((ServerActivity)this);
    }

    public void stop(StopContext context) {
        this.configuration.getSuspendController().unRegisterActivity((ServerActivity)this);
        this.configuration.getUndertowService().unregisterListener((UndertowEventListener)this);
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(this.configuration.getStatusInterval().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.configuration.getContainerEventHandler().stop(this.server);
    }

    private Context createContext(Deployment deployment, Host host) {
        return new UndertowContext(deployment, new UndertowHost(host, new UndertowEngine(this.serverName, host.getServer().getValue(), this.configuration.getUndertowService(), this.connector)));
    }

    private Context createContext(String contextPath, Host host) {
        return new LocationContext(contextPath, new UndertowHost(host, new UndertowEngine(this.serverName, host.getServer().getValue(), this.configuration.getUndertowService(), this.connector)));
    }

    private synchronized void onStart(Context context) {
        ContainerEventHandler handler = this.configuration.getContainerEventHandler();
        handler.add(context);
        handler.start(context);
        this.contexts.add(context);
    }

    private synchronized void onStop(Context context) {
        ContainerEventHandler handler = this.configuration.getContainerEventHandler();
        handler.stop(context);
        handler.remove(context);
        this.contexts.remove(context);
    }

    public void onDeploymentStart(Deployment deployment, Host host) {
        if (this.filter(host)) {
            this.onStart(this.createContext(deployment, host));
        }
    }

    public void onDeploymentStop(Deployment deployment, Host host) {
        if (this.filter(host)) {
            this.onStop(this.createContext(deployment, host));
        }
    }

    public void onDeploymentStart(String contextPath, Host host) {
        if (this.filter(host)) {
            this.onStart(this.createContext(contextPath, host));
        }
    }

    public void onDeploymentStop(String contextPath, Host host) {
        if (this.filter(host)) {
            this.onStop(this.createContext(contextPath, host));
        }
    }

    public boolean filter(Host host) {
        return host.getServer().getName().equals(this.serverName);
    }

    @Override
    public void run() {
        try {
            for (Engine engine : this.server.getEngines()) {
                this.configuration.getContainerEventHandler().status(engine);
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void preSuspend(ServerActivityCallback listener) {
        try {
            for (Context context : this.contexts) {
                this.configuration.getContainerEventHandler().stop(context);
            }
        }
        finally {
            listener.done();
        }
    }

    public void suspended(ServerActivityCallback listener) {
        listener.done();
    }

    public void resume() {
        for (Context context : this.contexts) {
            this.configuration.getContainerEventHandler().start(context);
        }
    }
}

