/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential;

import java.lang.reflect.Constructor;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.annotation.StereotypeProperty;

public interface Token {
    public String getType();

    public String getSubject();

    public String getToken();

    public static class Builder {
        public static Token create(String tokenType, String tokenValue) throws IdentityManagementException {
            try {
                Class tokenClazz = Reflections.classForName((String)tokenType, (ClassLoader[])new ClassLoader[0]);
                Constructor expectedConstructor = Reflections.findDeclaredConstructor((Class)tokenClazz, (Class[])new Class[]{String.class});
                if (expectedConstructor == null) {
                    throw new IdentityManagementException("Token type [" + tokenClazz.getName() + "] must provide a constructor that accepts a String.");
                }
                return (Token)expectedConstructor.newInstance(tokenValue);
            }
            catch (ClassCastException cce) {
                throw new IdentityManagementException("Wrong Token type [" + tokenType + "]. It must be a subclass of [" + Token.class.getName() + "].", cce);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IdentityManagementException("Token type not found [" + tokenType + "].", cnfe);
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not create Token type [" + tokenType + "].", e);
            }
        }
    }

    public static interface Consumer<T extends Token> {
        public <I extends IdentityType> I extractIdentity(T var1, Class<I> var2, StereotypeProperty.Property var3, Object var4);

        public boolean validate(T var1);

        public Class<T> getTokenType();
    }

    public static interface Provider<T extends Token> {
        public T issue(Account var1);

        public T renew(Account var1, T var2);

        public void invalidate(Account var1);

        public Class<T> getTokenType();
    }
}

