/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.jboss.logging.Logger;

public class ExternalCertificateLoginModule
implements LoginModule {
    private static final Logger logger = Logger.getLogger(ExternalCertificateLoginModule.class);
    private CallbackHandler callbackHandler;
    private Subject subject;
    private String userName;
    private final Set<Principal> principals = new HashSet<Principal>();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new CertificateCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Unable to obtain client certificates: " + uce.getMessage());
        }
        Object[] certificates = ((CertificateCallback)callbacks[0]).getCertificates();
        if (certificates != null && certificates.length > 0 && certificates[0] != null) {
            this.userName = ((X509Certificate)certificates[0]).getSubjectDN().getName();
        }
        logger.debug((Object)("Certificates: " + Arrays.toString(certificates) + ", userName: " + this.userName));
        return this.userName != null;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.userName != null) {
            this.principals.add(new UserPrincipal(this.userName));
            this.subject.getPrincipals().addAll(this.principals);
        }
        this.clear();
        logger.debug((Object)"commit");
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        logger.debug((Object)"abort");
        return true;
    }

    @Override
    public boolean logout() {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        logger.debug((Object)"logout");
        return true;
    }

    private void clear() {
        this.userName = null;
    }
}

