/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Collections;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.atomic.impl.AtomicMapProxyImpl;
import org.infinispan.atomic.impl.FineGrainedAtomicMapProxyImpl;
import org.infinispan.commons.util.Immutables;

public class AtomicMapLookup {
    public static <MK, K, V> AtomicMap<K, V> getAtomicMap(Cache<MK, ?> cache, MK key) {
        return AtomicMapLookup.getAtomicMap(cache, key, true);
    }

    public static <MK, K, V> FineGrainedAtomicMap<K, V> getFineGrainedAtomicMap(Cache<MK, ?> cache, MK key) {
        return AtomicMapLookup.getFineGrainedAtomicMap(cache, key, true);
    }

    public static <MK, K, V> AtomicMap<K, V> getAtomicMap(Cache<MK, ?> cache, MK key, boolean createIfAbsent) {
        return (AtomicMap)AtomicMapLookup.getMap(cache, key, createIfAbsent, false);
    }

    public static <MK, K, V> FineGrainedAtomicMap<K, V> getFineGrainedAtomicMap(Cache<MK, ?> cache, MK key, boolean createIfAbsent) {
        return (FineGrainedAtomicMap)AtomicMapLookup.getMap(cache, key, createIfAbsent, true);
    }

    private static <MK, K, V> Map<K, V> getMap(Cache<MK, Object> cache, MK key, boolean createIfAbsent, boolean fineGrained) {
        if (fineGrained) {
            return FineGrainedAtomicMapProxyImpl.newInstance(cache, key, createIfAbsent);
        }
        return AtomicMapProxyImpl.newInstance(cache, key, createIfAbsent);
    }

    public static <MK, K, V> Map<K, V> getReadOnlyAtomicMap(Cache<MK, ?> cache, MK key) {
        AtomicMap<K, V> am = AtomicMapLookup.getAtomicMap(cache, key, false);
        if (am == null) {
            return Collections.emptyMap();
        }
        return Immutables.immutableMapWrap(am);
    }

    public static <MK> void removeAtomicMap(Cache<MK, ?> cache, MK key) {
        FineGrainedAtomicMapProxyImpl.removeMap(cache, key);
    }
}

