/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.extension.messaging.activemq.AddIfAbsentStepHandler;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.JGroupsDiscoveryGroupDefinition;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.broadcast.CommandDispatcherBroadcastEndpointFactory;

public class JGroupsDiscoveryGroupAdd
extends AbstractAddStepHandler {
    public static final JGroupsDiscoveryGroupAdd INSTANCE = new JGroupsDiscoveryGroupAdd(true);
    public static final JGroupsDiscoveryGroupAdd LEGACY_INSTANCE = new JGroupsDiscoveryGroupAdd(false);
    private final boolean needLegacyCall;

    private JGroupsDiscoveryGroupAdd(boolean needLegacyCall) {
        super(JGroupsDiscoveryGroupDefinition.ATTRIBUTES);
        this.needLegacyCall = needLegacyCall;
    }

    private static boolean isSubsystemResource(OperationContext context) {
        return "subsystem".equals(context.getCurrentAddress().getParent().getLastElement().getKey());
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        CommonAttributes.renameChannelToCluster(operation);
        if (operation.hasDefined(JGroupsDiscoveryGroupDefinition.JGROUPS_CHANNEL_FACTORY.getName()) && !operation.hasDefined(JGroupsDiscoveryGroupDefinition.JGROUPS_CHANNEL.getName())) {
            String channel = operation.get(CommonAttributes.JGROUPS_CLUSTER.getName()).asString();
            operation.get(JGroupsDiscoveryGroupDefinition.JGROUPS_CHANNEL.getName()).set(channel);
            PathAddress channelAddress = JGroupsDiscoveryGroupAdd.isSubsystemResource(context) ? context.getCurrentAddress().getParent().getParent().append("subsystem", "jgroups").append("channel", channel) : context.getCurrentAddress().getParent().getParent().getParent().append("subsystem", "jgroups").append("channel", channel);
            ModelNode addChannelOperation = Util.createAddOperation((PathAddress)channelAddress);
            addChannelOperation.get("stack").set(operation.get(JGroupsDiscoveryGroupDefinition.JGROUPS_CHANNEL_FACTORY.getName()));
            context.addStep(addChannelOperation, (OperationStepHandler)AddIfAbsentStepHandler.INSTANCE, OperationContext.Stage.MODEL);
        }
        super.execute(context, operation);
        if (this.needLegacyCall) {
            PathAddress target = context.getCurrentAddress().getParent().append("discovery-group", context.getCurrentAddressValue());
            ModelNode op = operation.clone();
            op.get("address").set(target.toModelNode());
            context.addStep(op, (OperationStepHandler)DiscoveryGroupAdd.LEGACY_INSTANCE, OperationContext.Stage.MODEL, true);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceController service;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController serviceController = service = serviceName == null ? null : registry.getService(serviceName);
        if (service != null) {
            context.reloadRequired();
        }
    }

    static Map<String, DiscoveryGroupConfiguration> addDiscoveryGroupConfigs(OperationContext context, ModelNode model) throws OperationFailedException {
        HashMap<String, DiscoveryGroupConfiguration> configs = new HashMap<String, DiscoveryGroupConfiguration>();
        if (model.hasDefined("jgroups-discovery-group")) {
            for (Property prop : model.get("jgroups-discovery-group").asPropertyList()) {
                configs.put(prop.getName(), JGroupsDiscoveryGroupAdd.createDiscoveryGroupConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
        return configs;
    }

    static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        long refreshTimeout = DiscoveryGroupDefinition.REFRESH_TIMEOUT.resolveModelAttribute(context, model).asLong();
        long initialWaitTimeout = DiscoveryGroupDefinition.INITIAL_WAIT_TIMEOUT.resolveModelAttribute(context, model).asLong();
        return new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(initialWaitTimeout);
    }

    public static DiscoveryGroupConfiguration createDiscoveryGroupConfiguration(String name, DiscoveryGroupConfiguration config, CommandDispatcherFactory commandDispatcherFactory, String channelName) throws Exception {
        long refreshTimeout = config.getRefreshTimeout();
        long initialWaitTimeout = config.getDiscoveryInitialWaitTimeout();
        CommandDispatcherBroadcastEndpointFactory endpointFactory = new CommandDispatcherBroadcastEndpointFactory(commandDispatcherFactory, channelName);
        return new DiscoveryGroupConfiguration().setName(name).setRefreshTimeout(refreshTimeout).setDiscoveryInitialWaitTimeout(initialWaitTimeout).setBroadcastEndpointFactory((BroadcastEndpointFactory)endpointFactory);
    }
}

