/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InvalidateL1Command
extends InvalidateCommand {
    public static final int COMMAND_ID = 7;
    private static final Log log = LogFactory.getLog(InvalidateL1Command.class);
    private DistributionManager dm;
    private DataContainer dataContainer;
    private Address writeOrigin;

    public InvalidateL1Command() {
        this.writeOrigin = null;
    }

    public InvalidateL1Command(DataContainer dc, DistributionManager dm, CacheNotifier notifier, long flagsBitSet, CommandInvocationId commandInvocationId, Object ... keys) {
        super(notifier, flagsBitSet, commandInvocationId, keys);
        this.writeOrigin = null;
        this.dm = dm;
        this.dataContainer = dc;
    }

    public InvalidateL1Command(DataContainer dc, DistributionManager dm, CacheNotifier notifier, long flagsBitSet, Collection<Object> keys, CommandInvocationId commandInvocationId) {
        this(null, dc, dm, notifier, flagsBitSet, keys, commandInvocationId);
    }

    public InvalidateL1Command(Address writeOrigin, DataContainer dc, DistributionManager dm, CacheNotifier notifier, long flagsBitSet, Collection<Object> keys, CommandInvocationId commandInvocationId) {
        super(notifier, flagsBitSet, keys, commandInvocationId);
        this.writeOrigin = writeOrigin;
        this.dm = dm;
        this.dataContainer = dc;
    }

    @Override
    public byte getCommandId() {
        return 7;
    }

    public void init(DistributionManager dm, CacheNotifier n, DataContainer dc) {
        super.init(n);
        this.dm = dm;
        this.dataContainer = dc;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.tracef("Preparing to invalidate keys %s", Arrays.asList(this.keys));
        }
        for (Object k : this.getKeys()) {
            InternalCacheEntry ice = this.dataContainer.peek(k);
            if (ice == null) continue;
            boolean isLocal = this.dm.getCacheTopology().isWriteOwner(k);
            if (!isLocal) {
                if (trace) {
                    log.tracef("Invalidating key %s.", k);
                }
                MVCCEntry e = (MVCCEntry)ctx.lookupEntry(k);
                this.notify(ctx, e, true);
                e.setRemoved(true);
                e.setChanged(true);
                e.setCreated(false);
                e.setValid(false);
                continue;
            }
            log.tracef("Not invalidating key %s as it is local now", k);
        }
        return null;
    }

    public void setKeys(Object[] keys) {
        this.keys = keys;
    }

    @Override
    public Collection<?> getKeysToLock() {
        return Collections.emptyList();
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        super.writeTo(output);
        output.writeObject(this.writeOrigin);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        super.readFrom(input);
        this.writeOrigin = (Address)input.readObject();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitInvalidateL1Command(ctx, this);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{num keys=" + (this.keys == null ? 0 : this.keys.length) + ", origin=" + this.writeOrigin + '}';
    }

    public boolean isCausedByALocalWrite(Address address) {
        return this.writeOrigin != null && this.writeOrigin.equals(address);
    }
}

