/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.distribution.ch.impl.ScatteredConsistentHashFactory;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.infinispan.distribution.ch.impl.SyncReplicatedConsistentHashFactory;
import org.infinispan.distribution.ch.impl.TopologyAwareSyncConsistentHashFactory;
import org.infinispan.distribution.group.impl.PartitionerConsistentHash;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.persistence.manager.PreloadManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyHandler;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferManagerImpl
implements StateTransferManager {
    private static final Log log = LogFactory.getLog(StateTransferManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @ComponentName(value="cacheName")
    @Inject
    protected String cacheName;
    @Inject
    private StateConsumer stateConsumer;
    @Inject
    private StateProvider stateProvider;
    @Inject
    private PartitionHandlingManager partitionHandlingManager;
    @Inject
    private DistributionManager distributionManager;
    @Inject
    private CacheNotifier cacheNotifier;
    @Inject
    private Configuration configuration;
    @Inject
    private GlobalConfiguration globalConfiguration;
    @Inject
    private RpcManager rpcManager;
    @Inject
    private LocalTopologyManager localTopologyManager;
    @Inject
    private KeyPartitioner keyPartitioner;
    @Inject
    private GlobalStateManager globalStateManager;
    @Inject
    private PreloadManager preloadManager;
    @Inject
    private PerCacheInboundInvocationHandler inboundInvocationHandler;
    private Optional<Integer> persistentStateChecksum;
    private final CountDownLatch initialStateTransferComplete = new CountDownLatch(1);

    @Override
    @Start(priority=60)
    public void start() throws Exception {
        if (trace) {
            log.tracef("Starting StateTransferManager of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
        this.persistentStateChecksum = this.globalStateManager != null ? this.globalStateManager.readScopedState(this.cacheName).map(ScopedPersistentState::getChecksum) : Optional.empty();
        float capacityFactor = this.globalConfiguration.isZeroCapacityNode() ? 0.0f : this.configuration.clustering().hash().capacityFactor();
        CacheJoinInfo joinInfo = new CacheJoinInfo(StateTransferManagerImpl.pickConsistentHashFactory(this.globalConfiguration, this.configuration), this.configuration.clustering().hash().hash(), this.configuration.clustering().hash().numSegments(), this.configuration.clustering().hash().numOwners(), this.configuration.clustering().stateTransfer().timeout(), this.configuration.transaction().transactionProtocol().isTotalOrder(), this.configuration.clustering().cacheMode(), capacityFactor, this.localTopologyManager.getPersistentUUID(), this.persistentStateChecksum);
        CacheTopology initialTopology = this.localTopologyManager.join(this.cacheName, joinInfo, new CacheTopologyHandler(){

            @Override
            public void updateConsistentHash(CacheTopology cacheTopology) {
                StateTransferManagerImpl.this.doTopologyUpdate(cacheTopology, false);
            }

            @Override
            public void rebalance(CacheTopology cacheTopology) {
                StateTransferManagerImpl.this.doTopologyUpdate(cacheTopology, true);
            }
        }, this.partitionHandlingManager);
        if (trace) {
            log.tracef("StateTransferManager of cache %s on node %s received initial topology %s", this.cacheName, this.rpcManager.getAddress(), initialTopology);
        }
    }

    public static ConsistentHashFactory pickConsistentHashFactory(GlobalConfiguration globalConfiguration, Configuration configuration) {
        CacheMode cacheMode;
        ConsistentHashFactory<ReplicatedConsistentHash> factory = configuration.clustering().hash().consistentHashFactory();
        if (factory == null && (cacheMode = configuration.clustering().cacheMode()).isClustered()) {
            if (cacheMode.isDistributed()) {
                factory = globalConfiguration.transport().hasTopologyInfo() ? new TopologyAwareSyncConsistentHashFactory() : new SyncConsistentHashFactory();
            } else if (cacheMode.isReplicated() || cacheMode.isInvalidation()) {
                factory = new SyncReplicatedConsistentHashFactory();
            } else if (cacheMode.isScattered()) {
                factory = new ScatteredConsistentHashFactory();
            } else {
                throw new CacheException("Unexpected cache mode: " + (Object)((Object)cacheMode));
            }
        }
        return factory;
    }

    private CacheTopology addPartitioner(CacheTopology cacheTopology) {
        ConsistentHash unionCH;
        ConsistentHash currentCH = cacheTopology.getCurrentCH();
        currentCH = new PartitionerConsistentHash(currentCH, this.keyPartitioner);
        ConsistentHash pendingCH = cacheTopology.getPendingCH();
        if (pendingCH != null) {
            pendingCH = new PartitionerConsistentHash(pendingCH, this.keyPartitioner);
        }
        if ((unionCH = cacheTopology.getUnionCH()) != null) {
            unionCH = new PartitionerConsistentHash(unionCH, this.keyPartitioner);
        }
        return new CacheTopology(cacheTopology.getTopologyId(), cacheTopology.getRebalanceId(), currentCH, pendingCH, unionCH, cacheTopology.getPhase(), cacheTopology.getActualMembers(), cacheTopology.getMembersPersistentUUIDs());
    }

    private void doTopologyUpdate(CacheTopology newCacheTopology, boolean isRebalance) {
        LocalizedCacheTopology oldCacheTopology = this.distributionManager.getCacheTopology();
        int newTopologyId = newCacheTopology.getTopologyId();
        if (oldCacheTopology != null && oldCacheTopology.getTopologyId() > newTopologyId) {
            throw new IllegalStateException("Old topology is higher: old=" + oldCacheTopology + ", new=" + newCacheTopology);
        }
        if (trace) {
            log.tracef("Installing new cache topology %s on cache %s", newCacheTopology, this.cacheName);
        }
        if (!(!newCacheTopology.getMembers().contains(this.rpcManager.getAddress()) || this.distributionManager.getCacheTopology().isConnected() && this.distributionManager.getCacheTopology().getMembersSet().contains(this.rpcManager.getAddress()))) {
            if (trace) {
                log.tracef("This is the first topology %d in which the local node is a member", newTopologyId);
            }
            this.inboundInvocationHandler.setFirstTopologyAsMember(newTopologyId);
        }
        newCacheTopology = this.addPartitioner(newCacheTopology);
        int newRebalanceId = newCacheTopology.getRebalanceId();
        CacheTopology.Phase phase = newCacheTopology.getPhase();
        this.cacheNotifier.notifyTopologyChanged(oldCacheTopology, newCacheTopology, newTopologyId, true);
        CompletableFuture<Void> consumerFuture = this.stateConsumer.onTopologyUpdate(newCacheTopology, isRebalance);
        CompletableFuture<Void> providerFuture = this.stateProvider.onTopologyUpdate(newCacheTopology, isRebalance);
        CompletableFuture.allOf(consumerFuture, providerFuture).thenRun(() -> {
            switch (phase) {
                case TRANSITORY: 
                case READ_OLD_WRITE_ALL: 
                case READ_ALL_WRITE_ALL: 
                case READ_NEW_WRITE_ALL: {
                    this.localTopologyManager.confirmRebalancePhase(this.cacheName, newTopologyId, newRebalanceId, null);
                }
            }
        });
        this.cacheNotifier.notifyTopologyChanged(oldCacheTopology, newCacheTopology, newTopologyId, false);
        if (this.initialStateTransferComplete.getCount() > 0L) {
            boolean isJoined;
            assert (this.distributionManager.getCacheTopology().getTopologyId() == newCacheTopology.getTopologyId());
            boolean bl = isJoined = phase == CacheTopology.Phase.NO_REBALANCE && newCacheTopology.getReadConsistentHash().getMembers().contains(this.rpcManager.getAddress());
            if (isJoined) {
                this.initialStateTransferComplete.countDown();
                log.tracef("Initial state transfer complete for cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
            }
        }
        this.partitionHandlingManager.onTopologyUpdate(newCacheTopology);
    }

    @Override
    public void waitForInitialStateTransferToComplete() {
        if (this.configuration.clustering().stateTransfer().awaitInitialTransfer()) {
            try {
                boolean success;
                if (!this.localTopologyManager.isCacheRebalancingEnabled(this.cacheName)) {
                    this.initialStateTransferComplete.countDown();
                }
                if (trace) {
                    log.tracef("Waiting for initial state transfer to finish for cache %s on %s", this.cacheName, this.rpcManager.getAddress());
                }
                if (!(success = this.initialStateTransferComplete.await(this.configuration.clustering().stateTransfer().timeout(), TimeUnit.MILLISECONDS))) {
                    throw new CacheException(String.format("Initial state transfer timed out for cache %s on %s", this.cacheName, this.rpcManager.getAddress()));
                }
            }
            catch (CacheException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    @Override
    @Stop(priority=0)
    public void stop() {
        if (trace) {
            log.tracef("Shutting down StateTransferManager of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
        this.initialStateTransferComplete.countDown();
        this.localTopologyManager.leave(this.cacheName);
    }

    @Override
    public boolean isJoinComplete() {
        return this.distributionManager.getCacheTopology() != null;
    }

    @Override
    public String getRebalancingStatus() throws Exception {
        return this.localTopologyManager.getRebalancingStatus(this.cacheName).toString();
    }

    @Override
    public boolean isStateTransferInProgress() {
        return this.stateConsumer.isStateTransferInProgress();
    }

    @Override
    public boolean isStateTransferInProgressForKey(Object key) {
        return this.stateConsumer.isStateTransferInProgressForKey(key);
    }

    @Override
    public CacheTopology getCacheTopology() {
        return this.distributionManager.getCacheTopology();
    }

    @Override
    public Map<Address, Response> forwardCommandIfNeeded(TopologyAffectedCommand command, Set<Object> affectedKeys, Address origin) {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        if (cacheTopology == null) {
            if (trace) {
                log.tracef("Not fowarding command %s because topology is null.", command);
            }
            return Collections.emptyMap();
        }
        int cmdTopologyId = command.getTopologyId();
        int localTopologyId = cacheTopology.getTopologyId();
        if (trace) {
            log.tracef("CommandTopologyId=%s, localTopologyId=%s", cmdTopologyId, localTopologyId);
        }
        if (cmdTopologyId < localTopologyId) {
            HashSet<Address> newTargets = new HashSet<Address>(cacheTopology.getWriteOwners(affectedKeys));
            newTargets.remove(this.rpcManager.getAddress());
            newTargets.remove(origin);
            if (!newTargets.isEmpty()) {
                command.setTopologyId(localTopologyId);
                if (trace) {
                    log.tracef("Forwarding command %s to new targets %s", command, newTargets);
                }
                RpcOptions rpcOptions = this.rpcManager.getDefaultRpcOptions(false, DeliverOrder.NONE);
                return this.rpcManager.invokeRemotely(newTargets, command, rpcOptions);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean ownsData() {
        return this.stateConsumer.ownsData();
    }

    @Override
    public int getFirstTopologyAsMember() {
        return this.inboundInvocationHandler.getFirstTopologyAsMember();
    }

    public String toString() {
        return "StateTransferManagerImpl [" + this.cacheName + "@" + this.rpcManager.getAddress() + "]";
    }
}

