/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.user;

import io.airlift.airline.Command;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.user.UserAction;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoginModuleConfigurator;

@Command(name="list", description="List existing user(s)")
public class ListUser
extends UserAction {
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.list();
        return null;
    }

    private void list() throws Exception {
        PropertiesLoginModuleConfigurator config = new PropertiesLoginModuleConfigurator(this.entry, this.getBrokerEtc());
        Map result = config.listUser(this.username);
        StringBuilder logMessage = new StringBuilder("--- \"user\"(roles) ---\n");
        int userCount = 0;
        for (Map.Entry entry : result.entrySet()) {
            logMessage.append("\"").append((String)entry.getKey()).append("\"(");
            int roleCount = 0;
            for (String role : (Set)entry.getValue()) {
                logMessage.append(role);
                if (++roleCount >= ((Set)entry.getValue()).size()) continue;
                logMessage.append(",");
            }
            logMessage.append(")\n");
            ++userCount;
        }
        logMessage.append("\n Total: ").append(userCount);
        this.context.out.println(logMessage);
    }
}

