/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.activemq.artemis.jdbc.store.file.Db2SequentialFileDriver;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.jdbc.store.file.PostgresSequentialSequentialFileDriver;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

class JDBCFileUtils {
    JDBCFileUtils() {
    }

    static JDBCSequentialFileFactoryDriver getDBFileDriver(String driverClass, String jdbcConnectionUrl, String user, String password, SQLProvider provider) throws SQLException {
        PropertySQLProvider.Factory.SQLDialect sqlDialect = PropertySQLProvider.Factory.identifyDialect(driverClass);
        JDBCSequentialFileFactoryDriver dbDriver = PropertySQLProvider.Factory.SQLDialect.POSTGRESQL.equals((Object)sqlDialect) ? new PostgresSequentialSequentialFileDriver() : (PropertySQLProvider.Factory.SQLDialect.DB2.equals((Object)sqlDialect) ? new Db2SequentialFileDriver() : new JDBCSequentialFileFactoryDriver());
        dbDriver.setSqlProvider(provider);
        dbDriver.setJdbcConnectionUrl(jdbcConnectionUrl);
        dbDriver.setJdbcDriverClass(driverClass);
        dbDriver.setUser(user);
        dbDriver.setPassword(password);
        return dbDriver;
    }

    static JDBCSequentialFileFactoryDriver getDBFileDriver(DataSource dataSource, SQLProvider provider) throws SQLException {
        PropertySQLProvider.Factory.SQLDialect sqlDialect;
        try (Connection connection = dataSource.getConnection();){
            sqlDialect = PropertySQLProvider.Factory.investigateDialect(connection);
        }
        JDBCSequentialFileFactoryDriver dbDriver = PropertySQLProvider.Factory.SQLDialect.POSTGRESQL.equals((Object)sqlDialect) ? new PostgresSequentialSequentialFileDriver(dataSource, provider) : (PropertySQLProvider.Factory.SQLDialect.DB2.equals((Object)sqlDialect) ? new Db2SequentialFileDriver(dataSource, provider) : new JDBCSequentialFileFactoryDriver(dataSource, provider));
        return dbDriver;
    }

    static JDBCSequentialFileFactoryDriver getDBFileDriver(Connection connection, SQLProvider provider) throws SQLException {
        JDBCSequentialFileFactoryDriver dbDriver;
        PropertySQLProvider.Factory.SQLDialect sqlDialect = PropertySQLProvider.Factory.investigateDialect(connection);
        if (PropertySQLProvider.Factory.SQLDialect.POSTGRESQL.equals((Object)sqlDialect)) {
            dbDriver = new PostgresSequentialSequentialFileDriver(connection, provider);
            dbDriver.setConnection(connection);
        } else {
            dbDriver = PropertySQLProvider.Factory.SQLDialect.DB2.equals((Object)sqlDialect) ? new Db2SequentialFileDriver(connection, provider) : new JDBCSequentialFileFactoryDriver(connection, provider);
        }
        return dbDriver;
    }
}

