/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;

public class BackupAckCommand
extends BaseRpcCommand
implements InitializableCommand {
    public static final byte COMMAND_ID = 2;
    private CommandAckCollector commandAckCollector;
    private long id;
    private int topologyId;

    public BackupAckCommand() {
        super(null);
    }

    public BackupAckCommand(ByteString cacheName) {
        super(cacheName);
    }

    public BackupAckCommand(ByteString cacheName, long id, int topologyId) {
        super(cacheName);
        this.id = id;
        this.topologyId = topologyId;
    }

    @Override
    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.commandAckCollector = componentRegistry.getCommandAckCollector().running();
    }

    public void ack() {
        this.commandAckCollector.backupAck(this.id, this.getOrigin(), this.topologyId);
    }

    @Override
    public byte getCommandId() {
        return 2;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeLong(this.id);
        output.writeInt(this.topologyId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.id = input.readLong();
        this.topologyId = input.readInt();
    }

    @Override
    public String toString() {
        return "BackupAckCommand{id=" + this.id + ", topologyId=" + this.topologyId + '}';
    }
}

