/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;

public class BackupMultiKeyAckCommand
extends BaseRpcCommand
implements InitializableCommand {
    public static final byte COMMAND_ID = 41;
    private CommandAckCollector commandAckCollector;
    private int segment;
    private long id;
    private int topologyId;

    public BackupMultiKeyAckCommand() {
        super(null);
    }

    public BackupMultiKeyAckCommand(ByteString cacheName) {
        super(cacheName);
    }

    public BackupMultiKeyAckCommand(ByteString cacheName, long id, int segment, int topologyId) {
        super(cacheName);
        this.id = id;
        this.segment = segment;
        this.topologyId = topologyId;
    }

    @Override
    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.commandAckCollector = componentRegistry.getCommandAckCollector().running();
    }

    public void ack() {
        this.commandAckCollector.multiKeyBackupAck(this.id, this.getOrigin(), this.segment, this.topologyId);
    }

    @Override
    public byte getCommandId() {
        return 41;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeLong(this.id);
        output.writeInt(this.segment);
        output.writeInt(this.topologyId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.id = input.readLong();
        this.segment = input.readInt();
        this.topologyId = input.readInt();
    }

    @Override
    public String toString() {
        return "BackupMultiKeyAckCommand{id=" + this.id + ", segment=" + this.segment + ", topologyId=" + this.topologyId + '}';
    }
}

