/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.configuration.global.WhiteListConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.util.logging.Log;

public class SerializationConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<SerializationConfiguration> {
    private final AttributeSet attributes;
    private final WhiteListConfigurationBuilder whiteListBuilder;
    private Map<Integer, AdvancedExternalizer<?>> advancedExternalizers = new HashMap();

    SerializationConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.whiteListBuilder = new WhiteListConfigurationBuilder();
        this.attributes = SerializationConfiguration.attributeDefinitionSet();
    }

    public SerializationConfigurationBuilder marshaller(Marshaller marshaller) {
        this.attributes.attribute(SerializationConfiguration.MARSHALLER).set((Object)marshaller);
        return this;
    }

    public Marshaller getMarshaller() {
        return (Marshaller)this.attributes.attribute(SerializationConfiguration.MARSHALLER).get();
    }

    @Deprecated
    public SerializationConfigurationBuilder version(short marshallVersion) {
        Log.CONFIG.serializationVersionDeprecated();
        this.attributes.attribute(SerializationConfiguration.VERSION).set((Object)marshallVersion);
        return this;
    }

    @Deprecated
    public SerializationConfigurationBuilder version(String marshallVersion) {
        Log.CONFIG.serializationVersionDeprecated();
        this.version(Version.getVersionShort((String)marshallVersion));
        return this;
    }

    @Deprecated
    public <T> SerializationConfigurationBuilder addAdvancedExternalizer(int id, AdvancedExternalizer<T> advancedExternalizer) {
        AdvancedExternalizer<?> ext = this.advancedExternalizers.get(id);
        if (ext != null) {
            throw new CacheConfigurationException(String.format("Duplicate externalizer id found! Externalizer id=%d for %s is shared by another externalizer (%s)", id, advancedExternalizer.getClass().getName(), ext.getClass().getName()));
        }
        this.advancedExternalizers.put(id, advancedExternalizer);
        return this;
    }

    @Deprecated
    public <T> SerializationConfigurationBuilder addAdvancedExternalizer(AdvancedExternalizer<T> advancedExternalizer) {
        Integer id = advancedExternalizer.getId();
        if (id == null) {
            throw new CacheConfigurationException(String.format("No advanced externalizer identifier set for externalizer %s", advancedExternalizer.getClass().getName()));
        }
        this.addAdvancedExternalizer(id, advancedExternalizer);
        return this;
    }

    @Deprecated
    public <T> SerializationConfigurationBuilder addAdvancedExternalizer(AdvancedExternalizer<T> ... advancedExternalizers) {
        for (AdvancedExternalizer<T> advancedExternalizer : advancedExternalizers) {
            this.addAdvancedExternalizer(advancedExternalizer);
        }
        return this;
    }

    @Deprecated
    public SerializationConfigurationBuilder classResolver(Object classResolver) {
        this.attributes.attribute(SerializationConfiguration.CLASS_RESOLVER).set(classResolver);
        return this;
    }

    public SerializationConfigurationBuilder addContextInitializer(SerializationContextInitializer sci) {
        if (sci == null) {
            throw new CacheConfigurationException("SerializationContextInitializer cannot be null");
        }
        ((List)this.attributes.attribute(SerializationConfiguration.SERIALIZATION_CONTEXT_INITIALIZERS).computeIfAbsent(ArrayList::new)).add(sci);
        return this;
    }

    public SerializationConfigurationBuilder addContextInitializers(SerializationContextInitializer ... scis) {
        return this.addContextInitializers(Arrays.asList(scis));
    }

    public SerializationConfigurationBuilder addContextInitializers(List<SerializationContextInitializer> scis) {
        ((List)this.attributes.attribute(SerializationConfiguration.SERIALIZATION_CONTEXT_INITIALIZERS).computeIfAbsent(ArrayList::new)).addAll(scis);
        return this;
    }

    public WhiteListConfigurationBuilder whiteList() {
        return this.whiteListBuilder;
    }

    public void validate() {
    }

    public SerializationConfiguration create() {
        if (!this.advancedExternalizers.isEmpty()) {
            this.attributes.attribute(SerializationConfiguration.ADVANCED_EXTERNALIZERS).set(this.advancedExternalizers);
        }
        return new SerializationConfiguration(this.attributes.protect(), this.whiteListBuilder.create());
    }

    public SerializationConfigurationBuilder read(SerializationConfiguration template) {
        this.attributes.read(template.attributes());
        this.advancedExternalizers = template.advancedExternalizers();
        this.whiteListBuilder.read(template.whiteList());
        return this;
    }

    public String toString() {
        return "SerializationConfigurationBuilder [attributes=" + this.attributes + ", advancedExternalizers=" + this.advancedExternalizers + "]";
    }
}

