/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.threads;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.factories.threads.ThreadNameInfo;

public class DefaultThreadFactory
implements ThreadFactory {
    public static final String DEFAULT_PATTERN = "%c-%n-p%f-t%t";
    private final String name;
    private final ThreadGroup threadGroup;
    private final int initialPriority;
    private final String threadNamePattern;
    private final AtomicLong factoryThreadIndexSequence = new AtomicLong(1L);
    private final long factoryIndex;
    private static final AtomicLong globalThreadIndexSequence = new AtomicLong(1L);
    private static final AtomicLong factoryIndexSequence = new AtomicLong(1L);
    private String node;
    private String component;

    public DefaultThreadFactory(ThreadGroup threadGroup, int initialPriority, String threadNamePattern, String node, String component) {
        this(null, threadGroup, initialPriority, threadNamePattern, node, component);
    }

    public DefaultThreadFactory(String name, ThreadGroup threadGroup, int initialPriority, String threadNamePattern, String node, String component) {
        this.name = name;
        if (threadGroup == null) {
            SecurityManager sm = System.getSecurityManager();
            threadGroup = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }
        this.threadGroup = threadGroup;
        this.initialPriority = initialPriority;
        this.factoryIndex = factoryIndexSequence.getAndIncrement();
        if (threadNamePattern == null) {
            threadNamePattern = DEFAULT_PATTERN;
        }
        this.threadNamePattern = threadNamePattern;
        this.node = node;
        this.component = component;
    }

    public String getName() {
        return this.name;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String threadNamePattern() {
        return this.threadNamePattern;
    }

    public ThreadGroup threadGroup() {
        return this.threadGroup;
    }

    public int initialPriority() {
        return this.initialPriority;
    }

    @Override
    public Thread newThread(Runnable target) {
        return this.createThread(target);
    }

    private Thread createThread(Runnable target) {
        ThreadNameInfo nameInfo = new ThreadNameInfo(globalThreadIndexSequence.getAndIncrement(), this.factoryThreadIndexSequence.getAndIncrement(), this.factoryIndex, this.node, this.component);
        Thread thread = this.actualThreadCreate(this.threadGroup, target);
        thread.setName(nameInfo.format(thread, this.threadNamePattern));
        thread.setPriority(this.initialPriority);
        thread.setDaemon(true);
        return thread;
    }

    protected Thread actualThreadCreate(ThreadGroup threadGroup, Runnable target) {
        return new Thread(threadGroup, target);
    }
}

