/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.InitializableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.IntSetsExternalization;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class StreamResponseCommand<R>
extends BaseRpcCommand
implements InitializableCommand {
    public static final byte COMMAND_ID = 48;
    protected ClusterStreamManager csm;
    protected Object id;
    protected boolean complete;
    protected R response;
    protected IntSet missedSegments;

    protected StreamResponseCommand() {
        super(null);
    }

    public StreamResponseCommand(ByteString cacheName) {
        super(cacheName);
    }

    public StreamResponseCommand(ByteString cacheName, Address origin, Object id, boolean complete, R response) {
        this(cacheName, origin, id, complete, IntSets.immutableEmptySet(), response);
    }

    public StreamResponseCommand(ByteString cacheName, Address origin, Object id, boolean complete, IntSet missedSegments, R response) {
        super(cacheName);
        this.setOrigin(origin);
        this.id = id;
        this.complete = complete;
        this.response = response;
        this.missedSegments = missedSegments;
    }

    @Override
    public void init(ComponentRegistry componentRegistry, boolean isRemote) {
        this.csm = componentRegistry.getClusterStreamManager().running();
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        this.csm.receiveResponse(this.id, this.getOrigin(), this.complete, this.missedSegments, this.response);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 48;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.getOrigin());
        output.writeObject(this.id);
        output.writeBoolean(this.complete);
        IntSetsExternalization.writeTo((ObjectOutput)output, (IntSet)this.missedSegments);
        output.writeObject(this.response);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setOrigin((Address)input.readObject());
        this.id = input.readObject();
        this.complete = input.readBoolean();
        this.missedSegments = IntSetsExternalization.readFrom((ObjectInput)input);
        this.response = input.readObject();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("StreamResponseCommand{");
        sb.append("id=").append(this.id);
        sb.append(", complete=").append(this.complete);
        sb.append(", missedSegments=").append(this.missedSegments);
        sb.append(", response=").append(this.response);
        sb.append('}');
        return sb.toString();
    }
}

