/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.protostream.annotations.ProtoEnum;
import org.infinispan.protostream.annotations.ProtoEnumValue;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.ReservedProcessor;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XEnumConstant;
import org.infinispan.protostream.impl.Log;

public final class ProtoEnumTypeMetadata
extends ProtoTypeMetadata {
    private static final Log log = Log.LogFactory.getLog(ProtoEnumTypeMetadata.class);
    private SortedMap<Integer, ProtoEnumValueMetadata> membersByNumber;
    private Map<String, ProtoEnumValueMetadata> membersByName;

    ProtoEnumTypeMetadata(XClass enumClass) {
        super(ProtoEnumTypeMetadata.getProtoName(enumClass), enumClass);
    }

    private static String getProtoName(XClass enumClass) {
        ProtoName annotation = enumClass.getAnnotation(ProtoName.class);
        ProtoEnum protoEnumAnnotation = enumClass.getAnnotation(ProtoEnum.class);
        if (annotation != null) {
            if (protoEnumAnnotation != null) {
                throw new ProtoSchemaBuilderException("@ProtoEnum annotation cannot be used together with @ProtoName: " + enumClass.getName());
            }
            return annotation.value().isEmpty() ? enumClass.getSimpleName() : annotation.value();
        }
        return protoEnumAnnotation == null || protoEnumAnnotation.name().isEmpty() ? enumClass.getSimpleName() : protoEnumAnnotation.name();
    }

    @Override
    public void scanMemberAnnotations() {
        if (this.membersByNumber == null) {
            this.membersByNumber = new TreeMap<Integer, ProtoEnumValueMetadata>();
            this.membersByName = new HashMap<String, ProtoEnumValueMetadata>();
            for (XEnumConstant xEnumConstant : this.javaClass.getEnumConstants()) {
                ProtoEnumValue annotation = xEnumConstant.getAnnotation(ProtoEnumValue.class);
                if (annotation == null) {
                    throw new ProtoSchemaBuilderException("Enum constants must have the @ProtoEnumValue annotation: " + this.getJavaClassName() + '.' + xEnumConstant.getName());
                }
                if (this.membersByNumber.containsKey(annotation.number())) {
                    throw new ProtoSchemaBuilderException("Found duplicate definition of Protobuf enum tag " + annotation.number() + " on enum constant: " + this.getJavaClassName() + '.' + xEnumConstant.getName());
                }
                String name = annotation.name();
                if (name.isEmpty()) {
                    name = xEnumConstant.getName();
                }
                if (this.membersByName.containsKey(name)) {
                    throw new ProtoSchemaBuilderException("Found duplicate definition of Protobuf enum constant " + name + " on enum constant: " + this.getJavaClassName() + '.' + xEnumConstant.getName());
                }
                ProtoEnumValueMetadata pevm = new ProtoEnumValueMetadata(annotation.number(), name, xEnumConstant.getOrdinal(), xEnumConstant.getDeclaringClass().getCanonicalName() + '.' + xEnumConstant.getName(), xEnumConstant.getProtoDocs());
                this.membersByNumber.put(annotation.number(), pevm);
                this.membersByName.put(pevm.getProtoName(), pevm);
            }
            if (this.membersByNumber.isEmpty()) {
                throw new ProtoSchemaBuilderException("Enums without members are not allowed: " + this.getJavaClassName());
            }
        }
    }

    public SortedMap<Integer, ProtoEnumValueMetadata> getMembers() {
        this.scanMemberAnnotations();
        return this.membersByNumber;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public ProtoEnumValueMetadata getEnumMemberByName(String name) {
        this.scanMemberAnnotations();
        return this.membersByName.get(name);
    }

    @Override
    public void generateProto(IndentWriter iw) {
        XClass where;
        this.scanMemberAnnotations();
        iw.append("\n\n");
        ProtoEnumTypeMetadata.appendDocumentation(iw, this.getDocumentation());
        iw.append("enum ").append(this.name);
        if (BaseProtoSchemaGenerator.generateSchemaDebugComments) {
            iw.append(" /* ").append(this.getJavaClassName()).append(" */");
        }
        iw.append(" {\n");
        iw.inc();
        ReservedProcessor reserved = new ReservedProcessor();
        reserved.scan(this.javaClass);
        for (String memberName : this.membersByName.keySet()) {
            where = reserved.checkReserved(this.name);
            if (where == null) continue;
            throw new ProtoSchemaBuilderException("Protobuf enum value " + memberName + " of enum constant " + this.membersByName.get(memberName).getJavaEnumName() + " conflicts with 'reserved' statement in " + where.getCanonicalName());
        }
        Iterator<Object> iterator = this.membersByNumber.keySet().iterator();
        while (iterator.hasNext()) {
            int memberNumber = (Integer)iterator.next();
            where = reserved.checkReserved(memberNumber);
            if (where == null) continue;
            throw new ProtoSchemaBuilderException("Protobuf enum number " + memberNumber + " of enum constant " + ((ProtoEnumValueMetadata)this.membersByNumber.get(memberNumber)).getJavaEnumName() + " conflicts with 'reserved' statement in " + where.getCanonicalName());
        }
        reserved.generate(iw);
        for (ProtoEnumValueMetadata m : this.membersByNumber.values()) {
            m.generateProto(iw);
        }
        iw.dec();
        iw.append("}\n");
    }

    public String toString() {
        return "ProtoEnumTypeMetadata{name='" + this.name + '\'' + ", javaClass=" + this.javaClass + ", membersByNumber=" + this.membersByNumber + '}';
    }
}

