/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.commons.util.EntrySizeCalculator;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.MemoryStorageConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.BoundedSegmentedDataContainer;
import org.infinispan.container.impl.DefaultDataContainer;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.L1SegmentedDataContainer;
import org.infinispan.container.impl.PeekableTouchableContainerMap;
import org.infinispan.container.impl.PeekableTouchableMap;
import org.infinispan.container.offheap.BoundedOffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapConcurrentMap;
import org.infinispan.container.offheap.OffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.SegmentedBoundedOffHeapDataContainer;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.wildfly.clustering.infinispan.spi.DataContainerConfiguration;

@DefaultFactoryFor(classes={InternalDataContainer.class})
@SurvivesRestarts
public class DataContainerFactory<K, V>
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    public Object construct(String componentName) {
        MemoryConfiguration memory = this.configuration.memory();
        EvictionStrategy strategy = memory.evictionStrategy();
        if (strategy.isExceptionBased() || !strategy.isEnabled()) {
            return this.createUnboundedContainer();
        }
        DataContainer<?, ?> container = this.createBoundedDataContainer();
        memory.heapConfiguration().attributes().attribute(MemoryStorageConfiguration.SIZE).addListener((newSize, oldSize) -> container.resize(((Long)newSize.get()).longValue()));
        return container;
    }

    private DataContainer<?, ?> createUnboundedContainer() {
        boolean offHeap;
        ClusteringConfiguration clustering = this.configuration.clustering();
        boolean segmented = clustering.cacheMode().needsStateTransfer();
        int level = this.configuration.locking().concurrencyLevel();
        boolean bl = offHeap = this.configuration.memory().storageType() == StorageType.OFF_HEAP;
        if (segmented) {
            Supplier<PeekableTouchableMap> mapSupplier = offHeap ? this::createAndStartOffHeapConcurrentMap : PeekableTouchableContainerMap::new;
            int segments = clustering.hash().numSegments();
            return clustering.l1().enabled() ? new L1SegmentedDataContainer(mapSupplier, segments) : new DefaultSegmentedDataContainer(mapSupplier, segments);
        }
        return offHeap ? new OffHeapDataContainer() : DefaultDataContainer.unBoundedDataContainer((int)level);
    }

    private DataContainer<?, ?> createBoundedDataContainer() {
        ClusteringConfiguration clustering = this.configuration.clustering();
        boolean segmented = clustering.cacheMode().needsStateTransfer();
        int level = this.configuration.locking().concurrencyLevel();
        MemoryConfiguration memory = this.configuration.memory();
        boolean offHeap = memory.storageType() == StorageType.OFF_HEAP;
        long thresholdSize = memory.size();
        EvictionType type = memory.evictionType();
        DataContainerConfiguration config = (DataContainerConfiguration)this.configuration.module(DataContainerConfiguration.class);
        if (segmented) {
            int segments = clustering.hash().numSegments();
            if (offHeap) {
                return new SegmentedBoundedOffHeapDataContainer(segments, thresholdSize, type);
            }
            return type == EvictionType.COUNT ? new BoundedSegmentedDataContainer(segments, thresholdSize, new EvictableEntrySizeCalculator(config.evictable())) : new BoundedSegmentedDataContainer(segments, thresholdSize, type);
        }
        if (offHeap) {
            return new BoundedOffHeapDataContainer(thresholdSize, type);
        }
        return type == EvictionType.COUNT ? new EvictableDataContainer(thresholdSize, new EvictableEntrySizeCalculator(config.evictable())) : DefaultDataContainer.boundedDataContainer((int)level, (long)thresholdSize, (EvictionType)type);
    }

    private OffHeapConcurrentMap createAndStartOffHeapConcurrentMap() {
        OffHeapEntryFactory entryFactory = (OffHeapEntryFactory)this.basicComponentRegistry.getComponent(OffHeapEntryFactory.class).wired();
        OffHeapMemoryAllocator memoryAllocator = (OffHeapMemoryAllocator)this.basicComponentRegistry.getComponent(OffHeapMemoryAllocator.class).wired();
        return new OffHeapConcurrentMap(memoryAllocator, entryFactory, null);
    }

    private static class EvictableEntrySizeCalculator<K, V>
    implements EntrySizeCalculator<K, InternalCacheEntry<K, V>> {
        private final Predicate<K> evictable;

        EvictableEntrySizeCalculator(Predicate<K> evictable) {
            this.evictable = evictable;
        }

        public long calculateSize(K key, InternalCacheEntry<K, V> value) {
            return this.evictable.test(key) ? 1L : 0L;
        }
    }

    public static class EvictableDataContainer<K, V>
    extends DefaultDataContainer<K, V> {
        EvictableDataContainer(long size, EntrySizeCalculator<? super K, ? super InternalCacheEntry<K, V>> calculator) {
            super(size, calculator);
        }
    }
}

