/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Query;
import org.hibernate.search.query.facet.Facet;

public abstract class AbstractFacet
implements Facet {
    private final String facetingName;
    private final String facetFieldName;
    private final String sourceFieldName;
    private final String value;
    private final int count;

    public AbstractFacet(String facetingName, String facetFieldName, String sourceFieldName, String value, int count) {
        this.facetingName = facetingName;
        this.facetFieldName = facetFieldName;
        this.sourceFieldName = sourceFieldName;
        this.count = count;
        this.value = value;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    @Deprecated
    public String getFieldName() {
        return this.getFacetFieldName();
    }

    public String getFacetFieldName() {
        return this.facetFieldName;
    }

    public String getSourceFieldName() {
        return this.sourceFieldName;
    }

    @Override
    public String getFacetingName() {
        return this.facetingName;
    }

    @Override
    public abstract Query getFacetQuery();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFacet that = (AbstractFacet)o;
        if (this.facetingName != null ? !this.facetingName.equals(that.facetingName) : that.facetingName != null) {
            return false;
        }
        if (this.facetFieldName != null ? !this.facetFieldName.equals(that.facetFieldName) : that.facetFieldName != null) {
            return false;
        }
        if (this.sourceFieldName != null ? !this.sourceFieldName.equals(that.sourceFieldName) : that.sourceFieldName != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.facetingName != null ? this.facetingName.hashCode() : 0;
        result = 31 * result + (this.facetFieldName != null ? this.facetFieldName.hashCode() : 0);
        result = 31 * result + (this.sourceFieldName != null ? this.sourceFieldName.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AbstractFacet");
        sb.append("{facetingName='").append(this.facetingName).append('\'');
        sb.append(", facetFieldName='").append(this.facetFieldName).append('\'');
        sb.append(", sourceFieldName='").append(this.sourceFieldName).append('\'');
        sb.append(", value='").append(this.value).append('\'');
        sb.append(", count=").append(this.count);
        sb.append('}');
        return sb.toString();
    }
}

