/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.security;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.services.security.VaultReaderException;
import org.jboss.as.server.services.security.VaultReaderImpl;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class RuntimeVaultReader
extends AbstractVaultReader {
    private volatile Object lazyVaultReader;

    public RuntimeVaultReader() {
        if (this.getClass().getClassLoader() instanceof ModuleClassLoader) {
            if (!Module.getBootModuleLoader().iterateModules("org.picketbox", false).hasNext()) {
                throw new RuntimeException();
            }
        } else {
            try {
                Class.forName("org.jboss.security.vault.SecurityVaultFactory");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VaultReaderImpl getVault() {
        if (this.lazyVaultReader == null) {
            RuntimeVaultReader runtimeVaultReader = this;
            synchronized (runtimeVaultReader) {
                if (this.lazyVaultReader == null) {
                    try {
                        Class<?> lazyVaultReader = this.getClass().getClassLoader().loadClass("org.jboss.as.server.services.security.VaultReaderImpl");
                        this.lazyVaultReader = lazyVaultReader.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new VaultReaderException(e);
                    }
                }
            }
        }
        return (VaultReaderImpl)this.lazyVaultReader;
    }

    @Override
    protected void createVault(String fqn, Map<String, Object> options) throws VaultReaderException {
        this.getVault().createVault(fqn, options);
    }

    @Override
    protected void createVault(String fqn, String module, Map<String, Object> options) throws VaultReaderException {
        this.getVault().createVault(fqn, module, options);
    }

    @Override
    protected void destroyVault() {
        this.getVault().destroyVault();
    }

    public boolean isVaultFormat(String toCheck) {
        return this.getVault().isVaultFormat(toCheck);
    }

    public String retrieveFromVault(String vaultedData) {
        return this.getVault().retrieveFromVault(vaultedData);
    }
}

