/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class XSiteStateTransferConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<XSiteStateTransferConfiguration>,
ConfigurationBuilderInfo {
    private final BackupConfigurationBuilder backupConfigurationBuilder;
    private final AttributeSet attributes = XSiteStateTransferConfiguration.attributeDefinitionSet();

    public XSiteStateTransferConfigurationBuilder(ConfigurationBuilder builder, BackupConfigurationBuilder backupConfigurationBuilder) {
        super(builder);
        this.backupConfigurationBuilder = backupConfigurationBuilder;
    }

    public void validate() {
        int chunkSize = (Integer)this.attributes.attribute(StateTransferConfiguration.CHUNK_SIZE).get();
        if (chunkSize <= 0) {
            throw Log.CONFIG.invalidChunkSize(chunkSize);
        }
        if ((Long)this.attributes.attribute(XSiteStateTransferConfiguration.TIMEOUT).get() <= 0L) {
            throw Log.CONFIG.invalidXSiteStateTransferTimeout();
        }
        if ((Long)this.attributes.attribute(XSiteStateTransferConfiguration.WAIT_TIME).get() <= 0L) {
            throw Log.CONFIG.invalidXSiteStateTransferWaitTime();
        }
    }

    public ElementDefinition getElementDefinition() {
        return XSiteStateTransferConfiguration.ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public final XSiteStateTransferConfigurationBuilder chunkSize(int chunkSize) {
        this.attributes.attribute(XSiteStateTransferConfiguration.CHUNK_SIZE).set((Object)chunkSize);
        return this;
    }

    public final XSiteStateTransferConfigurationBuilder timeout(long timeout) {
        this.attributes.attribute(XSiteStateTransferConfiguration.TIMEOUT).set((Object)timeout);
        return this;
    }

    public final XSiteStateTransferConfigurationBuilder maxRetries(int maxRetries) {
        this.attributes.attribute(XSiteStateTransferConfiguration.MAX_RETRIES).set((Object)maxRetries);
        return this;
    }

    public final XSiteStateTransferConfigurationBuilder waitTime(long waitingTimeBetweenRetries) {
        this.attributes.attribute(XSiteStateTransferConfiguration.WAIT_TIME).set((Object)waitingTimeBetweenRetries);
        return this;
    }

    public final BackupConfigurationBuilder backup() {
        return this.backupConfigurationBuilder;
    }

    public XSiteStateTransferConfiguration create() {
        return new XSiteStateTransferConfiguration(this.attributes.protect());
    }

    public Builder<XSiteStateTransferConfiguration> read(XSiteStateTransferConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.attributes;
    }
}

