/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.tx.totalorder.TotalOrderPrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ClearCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.functional.impl.FunctionalNotifier;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.L1Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.NotifyHelper;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.util.EntryLoader;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;

@Scope(value=Scopes.NAMED_CACHE)
public interface ClusteringDependentLogic {
    public void start();

    public LocalizedCacheTopology getCacheTopology();

    @Deprecated
    default public boolean localNodeIsOwner(Object key) {
        return this.getCacheTopology().isWriteOwner(key);
    }

    @Deprecated
    default public boolean localNodeIsPrimaryOwner(Object key) {
        return this.getCacheTopology().getDistribution(key).isPrimary();
    }

    @Deprecated
    default public Address getPrimaryOwner(Object key) {
        return this.getCacheTopology().getDistribution(key).primary();
    }

    public CompletionStage<Void> commitEntry(CacheEntry var1, FlagAffectedCommand var2, InvocationContext var3, Flag var4, boolean var5);

    public Commit commitType(FlagAffectedCommand var1, InvocationContext var2, int var3, boolean var4);

    @Deprecated
    default public Collection<Address> getOwners(Collection<Object> keys) {
        return this.getCacheTopology().getWriteOwners(keys);
    }

    @Deprecated
    default public Collection<Address> getOwners(Object key) {
        return this.getCacheTopology().getWriteOwners(key);
    }

    public CompletionStage<EntryVersionsMap> createNewVersionsAndCheckForWriteSkews(VersionGenerator var1, TxInvocationContext var2, VersionedPrepareCommand var3);

    public Address getAddress();

    public static class ScatteredLogic
    extends DistributionLogic {
        protected CompletableFuture<Void> commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            throw new UnsupportedOperationException();
        }
    }

    public static class DistributionLogic
    extends AbstractClusteringDependentLogic {
        @Inject
        StateTransferLock stateTransferLock;
        private final WriteSkewHelper.KeySpecificLogic localNodeIsOwner = new WriteSkewHelper.KeySpecificLogic(){

            @Override
            public boolean performCheckOnSegment(int segment) {
                return this.getCacheTopology().getSegmentDistribution(segment).isWriteOwner();
            }
        };
        private final WriteSkewHelper.KeySpecificLogic localNodeIsPrimaryOwner = new WriteSkewHelper.KeySpecificLogic(){

            @Override
            public boolean performCheckOnSegment(int segment) {
                return this.getCacheTopology().getSegmentDistribution(segment).isPrimary();
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CompletionStage<Void> commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            Commit doCommit;
            Object key = entry.getKey();
            int segment = SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner);
            Object previousValue = null;
            Metadata previousMetadata = null;
            this.stateTransferLock.acquireSharedTopologyLock();
            CompletionStage<Void> stage = null;
            try {
                doCommit = this.commitType(command, ctx, segment, entry.isRemoved());
                boolean isL1Write = false;
                if (!doCommit.isCommit() && this.configuration.clustering().l1().enabled()) {
                    long lifespan;
                    if (!(entry.isRemoved() || (lifespan = entry.getLifespan()) >= 0L && lifespan <= this.configuration.clustering().l1().lifespan())) {
                        Metadata metadata = entry.getMetadata().builder().lifespan(this.configuration.clustering().l1().lifespan()).build();
                        entry.setMetadata(new L1Metadata(metadata));
                    }
                    isL1Write = true;
                    doCommit = Commit.COMMIT_NON_LOCAL;
                } else if (doCommit.isCommit() && entry.getMetadata() instanceof L1Metadata) {
                    throw new IllegalStateException("Local entries must not have L1 metadata");
                }
                if (doCommit.isCommit()) {
                    boolean skipL1Write;
                    InternalCacheEntry previousEntry = this.dataContainer.peek(segment, key);
                    if (previousEntry != null) {
                        previousValue = previousEntry.getValue();
                        previousMetadata = previousEntry.getMetadata();
                    }
                    boolean bl = skipL1Write = isL1Write && previousEntry != null && !previousEntry.isL1Entry();
                    if (!skipL1Write) {
                        stage = this.commitManager.commit(entry, trackFlag, segment, l1Invalidation || isL1Write, ctx);
                    }
                }
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
            if (doCommit.isCommit() && doCommit.isLocal()) {
                boolean created = entry.isCreated();
                boolean removed = entry.isRemoved();
                boolean expired = removed && entry instanceof MVCCEntry ? ((MVCCEntry)entry).isExpired() : false;
                if (stage == null) {
                    return NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, previousValue, previousMetadata, this.evictionManager);
                }
                Object finalPreviousValue = previousValue;
                Metadata finalPreviousMetadata = previousMetadata;
                return stage.thenCompose(ignore -> NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, finalPreviousValue, finalPreviousMetadata, this.evictionManager));
            }
            return stage == null ? CompletableFutures.completedNull() : stage;
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return totalOrder ? this.localNodeIsOwner : this.localNodeIsPrimaryOwner;
        }
    }

    public static class ReplicationLogic
    extends InvalidationLogic {
        @Inject
        StateTransferLock stateTransferLock;
        private final WriteSkewHelper.KeySpecificLogic localNodeIsPrimaryOwner = segment -> this.getCacheTopology().getSegmentDistribution(segment).isPrimary();

        @Override
        public Collection<Address> getOwners(Object key) {
            return null;
        }

        @Override
        public Collection<Address> getOwners(Collection<Object> keys) {
            if (keys.isEmpty()) {
                return Collections.emptyList();
            }
            return null;
        }

        @Override
        public Commit commitType(FlagAffectedCommand command, InvocationContext ctx, int segment, boolean removed) {
            return this.clusterCommitType(command, ctx, segment, removed);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CompletionStage<Void> commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            Commit doCommit;
            Object key = entry.getKey();
            int segment = SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner);
            Object previousValue = null;
            Metadata previousMetadata = null;
            CompletionStage<Void> stage = null;
            this.stateTransferLock.acquireSharedTopologyLock();
            try {
                doCommit = this.commitType(command, ctx, segment, entry.isRemoved());
                if (doCommit.isCommit()) {
                    InternalCacheEntry previousEntry = this.dataContainer.peek(segment, key);
                    if (previousEntry != null) {
                        previousValue = previousEntry.getValue();
                        previousMetadata = previousEntry.getMetadata();
                    }
                    stage = this.commitManager.commit(entry, trackFlag, segment, l1Invalidation, ctx);
                }
            }
            finally {
                this.stateTransferLock.releaseSharedTopologyLock();
            }
            if (doCommit.isCommit() && doCommit.isLocal()) {
                boolean created = entry.isCreated();
                boolean removed = entry.isRemoved();
                boolean expired = removed && entry instanceof MVCCEntry ? ((MVCCEntry)entry).isExpired() : false;
                if (stage == null) {
                    return NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, previousValue, previousMetadata, this.evictionManager);
                }
                Object finalPreviousValue = previousValue;
                Metadata finalPreviousMetadata = previousMetadata;
                return stage.thenCompose(ignore -> NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, finalPreviousValue, finalPreviousMetadata, this.evictionManager));
            }
            return stage == null ? CompletableFutures.completedNull() : stage;
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return totalOrder ? WriteSkewHelper.ALWAYS_TRUE_LOGIC : this.localNodeIsPrimaryOwner;
        }
    }

    public static class InvalidationLogic
    extends AbstractClusteringDependentLogic {
        @Override
        public Commit commitType(FlagAffectedCommand command, InvocationContext ctx, int segment, boolean removed) {
            return Commit.COMMIT_LOCAL;
        }

        @Override
        protected CompletionStage<Void> commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            Metadata previousMetadata;
            Object previousValue;
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean expired = removed && entry instanceof MVCCEntry ? ((MVCCEntry)entry).isExpired() : false;
            Object key = entry.getKey();
            int segment = SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner);
            InternalCacheEntry previousEntry = this.dataContainer.peek(segment, entry.getKey());
            if (previousEntry != null) {
                previousValue = previousEntry.getValue();
                previousMetadata = previousEntry.getMetadata();
            } else {
                previousValue = null;
                previousMetadata = null;
            }
            CompletionStage<Void> stage = this.commitManager.commit(entry, trackFlag, segment, l1Invalidation, ctx);
            return stage.thenCompose(ignore -> NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, previousValue, previousMetadata, this.evictionManager));
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return null;
        }
    }

    public static class LocalLogic
    extends AbstractClusteringDependentLogic {
        private LocalizedCacheTopology localTopology;

        @Inject
        public void init(Transport transport, Configuration configuration, KeyPartitioner keyPartitioner) {
            Address address = transport != null ? transport.getAddress() : LocalModeAddress.INSTANCE;
            boolean segmented = configuration.persistence().stores().stream().filter(StoreConfiguration::segmented).findAny().isPresent();
            this.localTopology = segmented ? LocalizedCacheTopology.makeSegmentedSingletonTopology(keyPartitioner, configuration.clustering().hash().numSegments(), address) : LocalizedCacheTopology.makeSingletonTopology(CacheMode.LOCAL, address);
        }

        @Override
        public LocalizedCacheTopology getCacheTopology() {
            return this.localTopology;
        }

        @Override
        public Address getAddress() {
            return this.localTopology.getLocalAddress();
        }

        @Override
        public Commit commitType(FlagAffectedCommand command, InvocationContext ctx, int segment, boolean removed) {
            return Commit.COMMIT_LOCAL;
        }

        @Override
        protected CompletionStage<Void> commitSingleEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            Metadata previousMetadata;
            Object previousValue;
            boolean created = entry.isCreated();
            boolean removed = entry.isRemoved();
            boolean expired = removed && entry instanceof MVCCEntry && ((MVCCEntry)entry).isExpired();
            Object key = entry.getKey();
            int segment = SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner);
            InternalCacheEntry previousEntry = this.dataContainer.peek(segment, entry.getKey());
            if (previousEntry != null) {
                previousValue = previousEntry.getValue();
                previousMetadata = previousEntry.getMetadata();
            } else {
                previousValue = null;
                previousMetadata = null;
            }
            CompletionStage<Void> stage = this.commitManager.commit(entry, trackFlag, segment, l1Invalidation, ctx);
            return stage.thenCompose(ignore -> NotifyHelper.entryCommitted(this.notifier, this.functionalNotifier, created, removed, expired, entry, ctx, command, previousValue, previousMetadata, this.evictionManager));
        }

        @Override
        protected WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean totalOrder) {
            return WriteSkewHelper.ALWAYS_TRUE_LOGIC;
        }
    }

    @Scope(value=Scopes.NAMED_CACHE)
    public static abstract class AbstractClusteringDependentLogic
    implements ClusteringDependentLogic {
        @Inject
        protected ComponentRegistry componentRegistry;
        @Inject
        protected DistributionManager distributionManager;
        @Inject
        protected InternalDataContainer<Object, Object> dataContainer;
        @Inject
        protected CacheNotifier<Object, Object> notifier;
        @Inject
        protected CommitManager commitManager;
        @Inject
        protected PersistenceManager persistenceManager;
        @Inject
        protected TimeService timeService;
        @Inject
        protected FunctionalNotifier<Object, Object> functionalNotifier;
        @Inject
        protected Configuration configuration;
        @Inject
        protected KeyPartitioner keyPartitioner;
        @Inject
        protected EvictionManager evictionManager;
        protected boolean totalOrder;
        private WriteSkewHelper.KeySpecificLogic keySpecificLogic;
        private EntryLoader entryLoader;

        @Override
        @Start
        public void start() {
            this.totalOrder = this.configuration.transaction().transactionProtocol().isTotalOrder();
            this.keySpecificLogic = this.initKeySpecificLogic(this.totalOrder);
            CacheLoaderInterceptor cli = this.componentRegistry.getComponent(CacheLoaderInterceptor.class);
            this.entryLoader = cli != null ? cli : (ctx, key, segment, cmd) -> {
                InternalCacheEntry<Object, Object> ice = this.dataContainer.peek(segment, key);
                if (ice != null && ice.canExpire() && ice.isExpired(this.timeService.wallClockTime())) {
                    ice = null;
                }
                return CompletableFuture.completedFuture(ice);
            };
        }

        @Override
        public CompletionStage<EntryVersionsMap> createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            return this.createNewVersionsMap(versionGenerator, context, prepareCommand);
        }

        private CompletionStage<EntryVersionsMap> createNewVersionsMap(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            return this.totalOrder ? this.totalOrderCreateNewVersionsAndCheckForWriteSkews(versionGenerator, context, prepareCommand) : this.clusteredCreateNewVersionsAndCheckForWriteSkews(versionGenerator, context, prepareCommand);
        }

        @Override
        public final CompletionStage<Void> commitEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
            if (entry instanceof ClearCacheEntry) {
                return this.commitClearCommand(this.dataContainer, ctx, command);
            }
            return this.commitSingleEntry(entry, command, ctx, trackFlag, l1Invalidation);
        }

        private CompletionStage<Void> commitClearCommand(DataContainer<Object, Object> dataContainer, InvocationContext context, FlagAffectedCommand command) {
            if (this.notifier.hasListener(CacheEntryRemoved.class)) {
                Iterator<InternalCacheEntry<Object, Object>> iterator = dataContainer.iteratorIncludingExpired();
                AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
                while (iterator.hasNext()) {
                    InternalCacheEntry<Object, Object> entry = iterator.next();
                    dataContainer.remove(entry.getKey());
                    aggregateCompletionStage.dependsOn(this.notifier.notifyCacheEntryRemoved(entry.getKey(), entry.getValue(), entry.getMetadata(), false, context, command));
                }
                return aggregateCompletionStage.freeze();
            }
            dataContainer.clear();
            return CompletableFutures.completedNull();
        }

        protected abstract CompletionStage<Void> commitSingleEntry(CacheEntry var1, FlagAffectedCommand var2, InvocationContext var3, Flag var4, boolean var5);

        protected Commit clusterCommitType(FlagAffectedCommand command, InvocationContext ctx, int segment, boolean removed) {
            boolean transactional;
            if (command != null && command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK)) {
                return Commit.COMMIT_LOCAL;
            }
            boolean bl = transactional = ctx.isInTxScope() && (command == null || !command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ));
            if (transactional || !ctx.isOriginLocal() || command != null && (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL) || command instanceof ClearCommand)) {
                if (this.getCacheTopology().isSegmentWriteOwner(segment)) {
                    return Commit.COMMIT_LOCAL;
                }
                if (removed) {
                    return Commit.COMMIT_NON_LOCAL;
                }
            } else {
                return this.getCacheTopology().getSegmentDistribution(segment).isPrimary() ? Commit.COMMIT_LOCAL : Commit.NO_COMMIT;
            }
            return Commit.NO_COMMIT;
        }

        @Override
        public Commit commitType(FlagAffectedCommand command, InvocationContext ctx, int segment, boolean removed) {
            return this.clusterCommitType(command, ctx, segment, removed);
        }

        protected abstract WriteSkewHelper.KeySpecificLogic initKeySpecificLogic(boolean var1);

        private CompletionStage<EntryVersionsMap> totalOrderCreateNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            if (context.isOriginLocal()) {
                throw new IllegalStateException("This must not be reached");
            }
            CompletionStage<EntryVersionsMap> updatedVersionMap = !((TotalOrderPrepareCommand)((Object)prepareCommand)).skipWriteSkewCheck() ? WriteSkewHelper.performTotalOrderWriteSkewCheckAndReturnNewVersions(prepareCommand, this.entryLoader, versionGenerator, context, this.keySpecificLogic, this.keyPartitioner) : CompletableFuture.completedFuture(new EntryVersionsMap());
            return updatedVersionMap.thenApply(uv -> {
                for (WriteCommand c : prepareCommand.getModifications()) {
                    for (Object k : c.getAffectedKeys()) {
                        int segment = SegmentSpecificCommand.extractSegment(c, k, this.keyPartitioner);
                        if (!this.keySpecificLogic.performCheckOnSegment(segment) || uv.containsKey(k)) continue;
                        uv.put(k, null);
                    }
                }
                ((AbstractCacheTransaction)context.getCacheTransaction()).setUpdatedEntryVersions((EntryVersionsMap)uv);
                return uv;
            });
        }

        private CompletionStage<EntryVersionsMap> clusteredCreateNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
            CompletionStage<EntryVersionsMap> uv = WriteSkewHelper.performWriteSkewCheckAndReturnNewVersions(prepareCommand, this.entryLoader, versionGenerator, context, this.keySpecificLogic, this.keyPartitioner);
            return uv.thenApply(evm -> {
                Object cacheTransaction = context.getCacheTransaction();
                EntryVersionsMap uvOld = cacheTransaction.getUpdatedEntryVersions();
                if (uvOld != null && !uvOld.isEmpty()) {
                    uvOld.putAll(evm);
                    evm = uvOld;
                }
                cacheTransaction.setUpdatedEntryVersions((EntryVersionsMap)evm);
                return evm.isEmpty() ? null : evm;
            });
        }

        @Override
        public LocalizedCacheTopology getCacheTopology() {
            return this.distributionManager.getCacheTopology();
        }

        @Override
        public Address getAddress() {
            return this.getCacheTopology().getLocalAddress();
        }
    }

    public static enum Commit {
        NO_COMMIT(false, false),
        COMMIT_NON_LOCAL(true, false),
        COMMIT_LOCAL(true, true);

        private boolean commit;
        private boolean local;

        private Commit(boolean commit, boolean local) {
            this.commit = commit;
            this.local = local;
        }

        public boolean isCommit() {
            return this.commit;
        }

        public boolean isLocal() {
            return this.local;
        }
    }
}

