/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.client;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.transaction.TransactionManager;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.StreamingRemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.impl.RemoteCacheSupport;
import org.infinispan.client.hotrod.jmx.RemoteCacheClientStatisticsMXBean;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorCollection;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.commons.util.IntSet;
import org.infinispan.query.dsl.Query;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;

public class RegisteredRemoteCache<K, V>
extends RemoteCacheSupport<K, V>
implements UnaryOperator<Registration> {
    private final Registrar<String> registrar;
    private final AtomicReference<Registration> registration;
    private final RemoteCacheManager manager;
    private final RemoteCache<K, V> cache;

    public RegisteredRemoteCache(RemoteCacheManager manager, RemoteCache<K, V> cache, Registrar<String> registrar) {
        this(manager, cache, registrar, new AtomicReference<Registration>());
    }

    private RegisteredRemoteCache(RemoteCacheManager manager, RemoteCache<K, V> cache, Registrar<String> registrar, AtomicReference<Registration> registration) {
        this.manager = manager;
        this.cache = cache;
        this.registrar = registrar;
        this.registration = registration;
    }

    public boolean isTransactional() {
        return this.cache.isTransactional();
    }

    public TransactionManager getTransactionManager() {
        return this.cache.getTransactionManager();
    }

    public void start() {
        if (this.registration.getAndUpdate(this) == null) {
            this.cache.start();
        }
    }

    @Override
    public Registration apply(Registration registration) {
        return registration == null ? this.registrar.register((Object)this.getName()) : registration;
    }

    public void stop() {
        try (Registration registration = this.registration.getAndSet(null);){
            if (registration != null) {
                this.cache.stop();
            }
        }
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return (V)this.cache.compute(key, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleUnit);
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.cache.computeIfAbsent(key, mappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeIfAbsentAsync(key, mappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return (V)this.cache.computeIfPresent(key, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleUnit);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return (V)this.cache.merge(key, value, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleUnit);
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.cache.mergeAsync(key, value, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleUnit);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeIfPresentAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return (V)this.cache.put(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return (V)this.cache.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return (V)this.cache.replace(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.replace(key, oldValue, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.replaceAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public V remove(Object key) {
        return (V)this.cache.remove(key);
    }

    public boolean remove(Object key, Object value) {
        return this.cache.remove(key, value);
    }

    public boolean removeWithVersion(K key, long version) {
        return this.cache.removeWithVersion(key, version);
    }

    public CompletableFuture<Boolean> removeWithVersionAsync(K key, long version) {
        return this.cache.removeWithVersionAsync(key, version);
    }

    public boolean replaceWithVersion(K key, V newValue, long version, int lifespanSeconds, int maxIdleTimeSeconds) {
        return this.cache.replaceWithVersion(key, newValue, version, lifespanSeconds, maxIdleTimeSeconds);
    }

    public boolean replaceWithVersion(K key, V newValue, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        return this.cache.replaceWithVersion(key, newValue, version, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit);
    }

    public CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version, int lifespanSeconds, int maxIdleSeconds) {
        return this.cache.replaceWithVersionAsync(key, newValue, version, lifespanSeconds, maxIdleSeconds);
    }

    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntries(String filterConverterFactory, Set<Integer> segments, int batchSize) {
        return this.cache.retrieveEntries(filterConverterFactory, segments, batchSize);
    }

    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntries(String filterConverterFactory, Object[] filterConverterParams, Set<Integer> segments, int batchSize) {
        return this.cache.retrieveEntries(filterConverterFactory, filterConverterParams, segments, batchSize);
    }

    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntries(String filterConverterFactory, int batchSize) {
        return this.cache.retrieveEntries(filterConverterFactory, batchSize);
    }

    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntriesByQuery(Query filterQuery, Set<Integer> segments, int batchSize) {
        return this.cache.retrieveEntriesByQuery(filterQuery, segments, batchSize);
    }

    public CloseableIterator<Map.Entry<Object, MetadataValue<Object>>> retrieveEntriesWithMetadata(Set<Integer> segments, int batchSize) {
        return this.cache.retrieveEntriesWithMetadata(segments, batchSize);
    }

    @Deprecated
    public VersionedValue<V> getVersioned(K key) {
        return this.cache.getVersioned(key);
    }

    public MetadataValue<V> getWithMetadata(K key) {
        return this.cache.getWithMetadata(key);
    }

    public CompletableFuture<MetadataValue<V>> getWithMetadataAsync(K key) {
        return this.cache.getWithMetadataAsync(key);
    }

    public CloseableIteratorSet<K> keySet() {
        return this.cache.keySet();
    }

    public CloseableIteratorSet<K> keySet(IntSet segments) {
        return this.cache.keySet(segments);
    }

    public CloseableIteratorCollection<V> values() {
        return this.cache.values();
    }

    public CloseableIteratorCollection<V> values(IntSet segments) {
        return this.cache.values(segments);
    }

    public CloseableIteratorSet<Map.Entry<K, V>> entrySet() {
        return this.cache.entrySet();
    }

    public CloseableIteratorSet<Map.Entry<K, V>> entrySet(IntSet segments) {
        return this.cache.entrySet(segments);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        this.cache.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleUnit);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public RemoteCacheClientStatisticsMXBean clientStatistics() {
        return this.cache.clientStatistics();
    }

    public ServerStatistics serverStatistics() {
        return this.cache.serverStatistics();
    }

    public RemoteCache<K, V> withFlags(Flag ... flags) {
        return new RegisteredRemoteCache<K, V>(this.manager, this.cache.withFlags(flags), this.registrar, this.registration);
    }

    public RemoteCacheManager getRemoteCacheManager() {
        return this.manager;
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        return this.cache.getAll(keys);
    }

    public String getProtocolVersion() {
        return this.cache.getProtocolVersion();
    }

    public void addClientListener(Object listener) {
        this.cache.addClientListener(listener);
    }

    public void addClientListener(Object listener, Object[] filterFactoryParams, Object[] converterFactoryParams) {
        this.cache.addClientListener(listener, filterFactoryParams, converterFactoryParams);
    }

    public void removeClientListener(Object listener) {
        this.cache.removeClientListener(listener);
    }

    @Deprecated
    public Set<Object> getListeners() {
        return this.cache.getListeners();
    }

    public <T> T execute(String scriptName, Map<String, ?> params) {
        return (T)this.cache.execute(scriptName, params);
    }

    public CacheTopologyInfo getCacheTopologyInfo() {
        return this.cache.getCacheTopologyInfo();
    }

    public StreamingRemoteCache<K> streaming() {
        return this.cache.streaming();
    }

    public <T, U> RemoteCache<T, U> withDataFormat(DataFormat dataFormat) {
        return new RegisteredRemoteCache<K, V>(this.manager, this.cache.withDataFormat(dataFormat), this.registrar, this.registration);
    }

    public DataFormat getDataFormat() {
        return this.cache.getDataFormat();
    }

    public String getName() {
        return this.cache.getName();
    }

    public String getVersion() {
        return this.cache.getVersion();
    }

    public CompletableFuture<Void> clearAsync() {
        return this.cache.clearAsync();
    }

    public CompletableFuture<V> getAsync(K arg0) {
        return this.cache.getAsync(arg0);
    }

    public CompletableFuture<V> removeAsync(Object key) {
        return this.cache.removeAsync(key);
    }

    public int size() {
        return this.cache.size();
    }

    public CompletableFuture<Long> sizeAsync() {
        return this.cache.sizeAsync();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    public V get(Object key) {
        return (V)this.cache.get(key);
    }

    public void clear() {
        this.cache.clear();
    }

    protected void set(K key, V value) {
        this.put(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }
}

