/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.Map;
import java.util.ServiceLoader;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ModuleServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.ServiceValueCaptorServiceConfigurator;
import org.jboss.as.clustering.controller.ServiceValueRegistry;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.GlobalConfigurationServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.KeyAffinityServiceFactoryServiceConfigurator;
import org.jboss.as.clustering.naming.BinderServiceConfigurator;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.service.IdentityServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceNameRegistry;
import org.wildfly.clustering.spi.CapabilityServiceNameRegistry;
import org.wildfly.clustering.spi.IdentityCacheServiceConfiguratorProvider;

public class CacheContainerServiceHandler
implements ResourceServiceHandler {
    private final ServiceValueRegistry<EmbeddedCacheManager> containerRegistry;
    private final ServiceValueRegistry<Cache<?, ?>> cacheRegistry;

    public CacheContainerServiceHandler(ServiceValueRegistry<EmbeddedCacheManager> containerRegistry, ServiceValueRegistry<Cache<?, ?>> cacheRegistry) {
        this.containerRegistry = containerRegistry;
        this.cacheRegistry = cacheRegistry;
    }

    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathElement ejbPath;
        Resource ejbResource;
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        if (context.getProcessType().isServer() && !context.isBooting() && name.equals("ejb") && (ejbResource = CacheContainerServiceHandler.safeGetResource(context, ejbPath = PathElement.pathElement((String)"subsystem", (String)"ejb3"))) != null && ejbResource.hasChild(PathElement.pathElement((String)"service", (String)"remote"))) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
            return;
        }
        ServiceTarget target = context.getServiceTarget();
        new ModuleServiceConfigurator(CacheContainerComponent.MODULE.getServiceName(address), (Attribute)CacheContainerResourceDefinition.Attribute.MODULE).configure(context, model).build(target).setInitialMode(ServiceController.Mode.PASSIVE).install();
        GlobalConfigurationServiceConfigurator configBuilder = new GlobalConfigurationServiceConfigurator(address);
        configBuilder.configure(context, model).build(target).install();
        CacheContainerServiceConfigurator containerBuilder = new CacheContainerServiceConfigurator(address, this.cacheRegistry).configure(context, model);
        containerBuilder.build(target).install();
        new ServiceValueCaptorServiceConfigurator(this.containerRegistry.add(containerBuilder.getServiceName())).build(target).install();
        new KeyAffinityServiceFactoryServiceConfigurator(address).build(target).install();
        new BinderServiceConfigurator(InfinispanBindingFactory.createCacheContainerBinding(name), containerBuilder.getServiceName()).build(target).install();
        String defaultCache = CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE.resolveModelAttribute((ExpressionResolver)context, model).asString(null);
        if (defaultCache != null) {
            for (Map.Entry<InfinispanCacheRequirement, Capability> entry : CacheContainerResourceDefinition.DEFAULT_CAPABILITIES.entrySet()) {
                new IdentityServiceConfigurator(entry.getValue().getServiceName(address), entry.getKey().getServiceName(context, name, defaultCache)).build(target).install();
            }
            if (!defaultCache.equals("default")) {
                new BinderServiceConfigurator(InfinispanBindingFactory.createCacheBinding(name, "default"), CacheContainerResourceDefinition.DEFAULT_CAPABILITIES.get(InfinispanCacheRequirement.CACHE).getServiceName(address)).build(target).install();
                new BinderServiceConfigurator(InfinispanBindingFactory.createCacheConfigurationBinding(name, "default"), CacheContainerResourceDefinition.DEFAULT_CAPABILITIES.get(InfinispanCacheRequirement.CONFIGURATION).getServiceName(address)).build(target).install();
            }
            CapabilityServiceNameRegistry registry = new CapabilityServiceNameRegistry(CacheContainerResourceDefinition.DEFAULT_CLUSTERING_CAPABILITIES, address);
            for (IdentityCacheServiceConfiguratorProvider provider : ServiceLoader.load(IdentityCacheServiceConfiguratorProvider.class, IdentityCacheServiceConfiguratorProvider.class.getClassLoader())) {
                for (CapabilityServiceConfigurator configurator : provider.getServiceConfigurators((ServiceNameRegistry)registry, name, null, defaultCache)) {
                    configurator.configure(context).build(target).install();
                }
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = context.getCurrentAddressValue();
        String defaultCache = CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE.resolveModelAttribute((ExpressionResolver)context, model).asString(null);
        if (defaultCache != null) {
            CapabilityServiceNameRegistry registry = new CapabilityServiceNameRegistry(CacheContainerResourceDefinition.DEFAULT_CLUSTERING_CAPABILITIES, address);
            for (IdentityCacheServiceConfiguratorProvider provider : ServiceLoader.load(IdentityCacheServiceConfiguratorProvider.class, IdentityCacheServiceConfiguratorProvider.class.getClassLoader())) {
                for (ServiceNameProvider configurator : provider.getServiceConfigurators((ServiceNameRegistry)registry, name, null, defaultCache)) {
                    context.removeService(configurator.getServiceName());
                }
            }
            if (!defaultCache.equals("default")) {
                context.removeService(InfinispanBindingFactory.createCacheBinding(name, "default").getBinderServiceName());
                context.removeService(InfinispanBindingFactory.createCacheConfigurationBinding(name, "default").getBinderServiceName());
            }
            for (Capability capability : CacheContainerResourceDefinition.DEFAULT_CAPABILITIES.values()) {
                context.removeService(capability.getServiceName(address));
            }
        }
        context.removeService(InfinispanBindingFactory.createCacheContainerBinding(name).getBinderServiceName());
        context.removeService(CacheContainerComponent.MODULE.getServiceName(address));
        for (Capability capability : EnumSet.allOf(CacheContainerResourceDefinition.Capability.class)) {
            context.removeService(capability.getServiceName(address));
        }
        context.removeService(new ServiceValueCaptorServiceConfigurator(this.containerRegistry.remove(CacheContainerResourceDefinition.Capability.CONTAINER.getServiceName(address))).getServiceName());
    }

    private static Resource safeGetResource(OperationContext context, PathElement path) {
        try {
            return context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{path}), false);
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

