/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;

public class SubDeploymentDependencyProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Object parentModule;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ModuleSpecification parentModuleSpec = parent.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleSpecification moduleSpec = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        ModuleIdentifier moduleIdentifier = deploymentUnit.getAttachment(Attachments.MODULE_IDENTIFIER);
        if (deploymentUnit.getParent() != null && (parentModule = parent.getAttachment(Attachments.MODULE_IDENTIFIER)) != null) {
            ModuleDependency moduleDependency = new ModuleDependency(moduleLoader, (ModuleIdentifier)parentModule, false, false, true, false);
            moduleDependency.addImportFilter(PathFilters.acceptAll(), true);
            moduleSpec.addLocalDependency(moduleDependency);
        }
        for (AdditionalModuleSpecification module : deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_MODULES)) {
            module.addLocalDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, true, false));
        }
        List<DeploymentUnit> subDeployments = parent.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
        ArrayList<ModuleDependency> accessibleModules = new ArrayList<ModuleDependency>();
        for (DeploymentUnit subDeployment : subDeployments) {
            ModuleSpecification subModule = subDeployment.getAttachment(Attachments.MODULE_SPECIFICATION);
            if (subModule.isPrivateModule() || parentModuleSpec.isSubDeploymentModulesIsolated() && !subModule.isPublicModule()) continue;
            ModuleIdentifier identifier = subDeployment.getAttachment(Attachments.MODULE_IDENTIFIER);
            ModuleDependency dependency = new ModuleDependency(moduleLoader, identifier, false, false, true, false);
            dependency.addImportFilter(PathFilters.acceptAll(), true);
            accessibleModules.add(dependency);
        }
        for (ModuleDependency dependency : accessibleModules) {
            if (dependency.getIdentifier().equals(moduleIdentifier)) continue;
            moduleSpec.addLocalDependency(dependency);
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

