/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.encoding;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Optional;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ProtostreamTranscoder
extends OneToManyTranscoder {
    public static final String WRAPPED_PARAM = "wrapped";
    protected static final Log logger = LogFactory.getLog(ProtostreamTranscoder.class, Log.class);
    private final SerializationContextRegistry ctxRegistry;
    private final ClassLoader classLoader;

    public ProtostreamTranscoder(SerializationContextRegistry ctxRegistry, ClassLoader classLoader) {
        super(MediaType.APPLICATION_PROTOSTREAM, new MediaType[]{MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JSON, MediaType.APPLICATION_UNKNOWN});
        this.ctxRegistry = ctxRegistry;
        this.classLoader = classLoader;
    }

    private ImmutableSerializationContext ctx() {
        return this.ctxRegistry.getGlobalCtx();
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            if (destinationType.match(MediaType.APPLICATION_PROTOSTREAM)) {
                Object decoded = content;
                if (contentType.match(MediaType.APPLICATION_OBJECT)) {
                    decoded = StandardConversions.decodeObjectContent((Object)content, (MediaType)contentType);
                    return this.marshall(decoded, destinationType);
                }
                if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                    decoded = StandardConversions.decodeOctetStream((Object)content, (MediaType)destinationType);
                }
                if (contentType.match(MediaType.TEXT_PLAIN)) {
                    decoded = StandardConversions.convertTextToObject((Object)content, (MediaType)contentType);
                }
                if (contentType.match(MediaType.APPLICATION_JSON)) {
                    Reader reader = (content = this.addTypeIfNeeded(content)) instanceof byte[] ? new InputStreamReader(new ByteArrayInputStream((byte[])content)) : new StringReader(content.toString());
                    return ProtobufUtil.fromCanonicalJSON((ImmutableSerializationContext)this.ctx(), (Reader)reader);
                }
                if (contentType.match(MediaType.APPLICATION_UNKNOWN) || contentType.match(MediaType.APPLICATION_PROTOSTREAM)) {
                    return content;
                }
                return this.marshall(decoded, destinationType);
            }
            if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                Object unmarshalled;
                Object object = unmarshalled = content instanceof byte[] ? this.unmarshall((byte[])content, contentType, destinationType) : content;
                if (unmarshalled instanceof byte[]) {
                    return unmarshalled;
                }
                return StandardConversions.convertJavaToProtoStream((Object)unmarshalled, (MediaType)MediaType.APPLICATION_OBJECT, (ImmutableSerializationContext)this.ctx());
            }
            if (destinationType.match(MediaType.TEXT_PLAIN)) {
                Object decoded = ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.ctx(), (byte[])((byte[])content));
                if (decoded == null) {
                    return null;
                }
                return decoded.toString().getBytes(destinationType.getCharset());
            }
            if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
                return this.unmarshall((byte[])content, contentType, destinationType);
            }
            if (destinationType.match(MediaType.APPLICATION_JSON)) {
                String converted = ProtobufUtil.toCanonicalJSON((ImmutableSerializationContext)this.ctx(), (byte[])((byte[])content));
                String convertType = destinationType.getClassType();
                if (convertType == null) {
                    return StandardConversions.convertCharset((Object)converted, (Charset)contentType.getCharset(), (Charset)destinationType.getCharset());
                }
                if (destinationType.hasStringType()) {
                    return converted;
                }
            }
            if (destinationType.equals((Object)MediaType.APPLICATION_UNKNOWN)) {
                if (content instanceof WrappedByteArray) {
                    return content;
                }
                return StandardConversions.convertJavaToProtoStream((Object)content, (MediaType)MediaType.APPLICATION_OBJECT, (ImmutableSerializationContext)this.ctx());
            }
            throw logger.unsupportedContent(ProtostreamTranscoder.class.getSimpleName(), content);
        }
        catch (IOException | InterruptedException e) {
            throw logger.errorTranscoding(ProtostreamTranscoder.class.getSimpleName(), e);
        }
    }

    private boolean isWrapped(MediaType mediaType) {
        Optional wrappedParam = mediaType.getParameter(WRAPPED_PARAM);
        return !wrappedParam.isPresent() || !((String)wrappedParam.get()).equals("false");
    }

    private byte[] marshall(Object decoded, MediaType destinationType) throws IOException {
        try {
            if (this.isWrapped(destinationType)) {
                return ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)this.ctx(), (Object)decoded);
            }
            return ProtobufUtil.toByteArray((ImmutableSerializationContext)this.ctx(), (Object)decoded);
        }
        catch (IllegalArgumentException iae) {
            throw new MarshallingException(iae.getMessage());
        }
    }

    private Object unmarshall(byte[] bytes, MediaType contentType, MediaType destinationType) throws IOException {
        try {
            String type = destinationType.getClassType();
            boolean wrapped = this.isWrapped(contentType);
            if (type == null) {
                if (wrapped) {
                    return ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.ctx(), (byte[])bytes);
                }
                throw logger.missingTypeForUnwrappedPayload();
            }
            Class destination = Util.loadClass((String)type, (ClassLoader)this.classLoader);
            return ProtobufUtil.fromByteArray((ImmutableSerializationContext)this.ctx(), (byte[])bytes, (Class)destination);
        }
        catch (IllegalArgumentException iae) {
            throw new MarshallingException(iae.getMessage());
        }
    }

    private Object addTypeIfNeeded(Object content) {
        String wrapped = "{ \"_type\":\"%s\", \"_value\":\"%s\"}";
        if (content instanceof Integer || content instanceof Short) {
            return String.format(wrapped, "int32", content);
        }
        if (content instanceof Long) {
            return String.format(wrapped, "int64", content);
        }
        if (content instanceof Double) {
            return String.format(wrapped, "double", content);
        }
        if (content instanceof Float) {
            return String.format(wrapped, "float", content);
        }
        if (content instanceof Boolean) {
            return String.format(wrapped, "bool", content);
        }
        if (content instanceof String && !content.toString().contains("_type")) {
            return String.format(wrapped, "string", content);
        }
        return content;
    }
}

