/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.status;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.CacheUnreachableException;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;
import org.infinispan.util.logging.events.Messages;
import org.infinispan.xsite.OfflineStatus;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.notification.SiteStatusListener;
import org.infinispan.xsite.status.BringSiteOnlineResponse;
import org.infinispan.xsite.status.SiteState;
import org.infinispan.xsite.status.TakeOfflineManager;
import org.infinispan.xsite.status.TakeSiteOfflineResponse;
import org.jgroups.UnreachableException;

@Scope(value=Scopes.NAMED_CACHE)
public class DefaultTakeOfflineManager
implements TakeOfflineManager,
XSiteResponse.XSiteResponseCompleted {
    private static final Log log = LogFactory.getLog(DefaultTakeOfflineManager.class);
    private final String cacheName;
    private final Map<String, OfflineStatus> offlineStatus;
    @Inject
    TimeService timeService;
    @Inject
    Configuration config;
    @Inject
    EventLogManager eventLogManager;
    @Inject
    RpcManager rpcManager;

    public DefaultTakeOfflineManager(String cacheName) {
        this.cacheName = cacheName;
        this.offlineStatus = new ConcurrentHashMap<String, OfflineStatus>();
    }

    public static boolean isCommunicationError(Throwable throwable) {
        Throwable error = throwable;
        if (throwable instanceof ExecutionException) {
            error = throwable.getCause();
        }
        return error instanceof TimeoutException || error instanceof org.infinispan.util.concurrent.TimeoutException || error instanceof UnreachableException || error instanceof CacheUnreachableException || error instanceof SuspectException;
    }

    private static boolean isConfigurationError(Throwable throwable) {
        Throwable error = throwable;
        if (throwable instanceof ExecutionException || throwable instanceof RemoteException) {
            error = throwable.getCause();
        }
        return error instanceof CacheConfigurationException;
    }

    @Start
    public void start() {
        this.config.sites().enabledBackupStream().forEach(bc -> {
            String siteName = bc.site();
            OfflineStatus offline = new OfflineStatus(bc.takeOffline(), this.timeService, new Listener(siteName));
            this.offlineStatus.put(siteName, offline);
        });
    }

    @Override
    public void registerRequest(XSiteResponse response) {
        response.whenCompleted(this);
    }

    @Override
    public SiteState getSiteState(String siteName) {
        OfflineStatus offline = this.offlineStatus.get(siteName);
        if (offline == null) {
            return SiteState.NOT_FOUND;
        }
        return offline.isOffline() ? SiteState.OFFLINE : SiteState.ONLINE;
    }

    @Override
    public void amendConfiguration(String siteName, Integer afterFailures, Long minTimeToWait) {
        OfflineStatus status = this.offlineStatus.get(siteName);
        if (status == null) {
            return;
        }
        status.amend(afterFailures, minTimeToWait);
    }

    @Override
    public TakeOfflineConfiguration getConfiguration(String siteName) {
        OfflineStatus status = this.offlineStatus.get(siteName);
        return status == null ? null : status.getTakeOffline();
    }

    @Override
    public Map<String, Boolean> status() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(this.offlineStatus.size());
        for (Map.Entry<String, OfflineStatus> os : this.offlineStatus.entrySet()) {
            result.put(os.getKey(), !os.getValue().isOffline());
        }
        return result;
    }

    @Override
    public BringSiteOnlineResponse bringSiteOnline(String siteName) {
        OfflineStatus status = this.offlineStatus.get(siteName);
        if (status == null) {
            log.tryingToBringOnlineNonexistentSite(siteName);
            return BringSiteOnlineResponse.NO_SUCH_SITE;
        }
        return status.bringOnline() ? BringSiteOnlineResponse.BROUGHT_ONLINE : BringSiteOnlineResponse.ALREADY_ONLINE;
    }

    @Override
    public TakeSiteOfflineResponse takeSiteOffline(String siteName) {
        OfflineStatus status = this.offlineStatus.get(siteName);
        if (status == null) {
            return TakeSiteOfflineResponse.NO_SUCH_SITE;
        }
        return status.forceOffline() ? TakeSiteOfflineResponse.TAKEN_OFFLINE : TakeSiteOfflineResponse.ALREADY_OFFLINE;
    }

    @Override
    public void onCompleted(XSiteBackup backup, long sendTimeNanos, long durationNanos, Throwable throwable) {
        OfflineStatus status = this.offlineStatus.get(backup.getSiteName());
        assert (status != null);
        if (DefaultTakeOfflineManager.isConfigurationError(throwable)) {
            log.xsiteInvalidConfigurationRemoteSite(backup.getSiteName());
            status.forceOffline();
            return;
        }
        if (status.isEnabled()) {
            if (DefaultTakeOfflineManager.isCommunicationError(throwable)) {
                status.updateOnCommunicationFailure(TimeUnit.NANOSECONDS.toMillis(sendTimeNanos));
            } else if (!status.isOffline()) {
                status.reset();
            }
        }
    }

    public OfflineStatus getOfflineStatus(String siteName) {
        return this.offlineStatus.get(siteName);
    }

    public String toString() {
        return "DefaultTakeOfflineManager{cacheName='" + this.cacheName + "'}";
    }

    private EventLogger getEventLogger() {
        return this.eventLogManager.getEventLogger().context(this.cacheName).scope(this.rpcManager.getAddress());
    }

    private class Listener
    implements SiteStatusListener {
        private final String siteName;

        private Listener(String siteName) {
            this.siteName = siteName;
        }

        @Override
        public void siteOnline() {
            DefaultTakeOfflineManager.this.getEventLogger().info(EventLogCategory.CLUSTER, Messages.MESSAGES.siteOnline(this.siteName));
        }

        @Override
        public void siteOffline() {
            DefaultTakeOfflineManager.this.getEventLogger().info(EventLogCategory.CLUSTER, Messages.MESSAGES.siteOffline(this.siteName));
        }

        public String toString() {
            return "Listener{siteName='" + this.siteName + '\'' + '}';
        }
    }
}

