/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.FunctionExecutorRegistry;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.singleton.Singleton;
import org.wildfly.extension.clustering.singleton.SingletonExtension;
import org.wildfly.extension.clustering.singleton.SingletonMetric;
import org.wildfly.extension.clustering.singleton.SingletonModel;
import org.wildfly.extension.clustering.singleton.SingletonServiceMetricExecutor;

public class SingletonServiceResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration> {
    static final PathElement WILDCARD_PATH = SingletonServiceResourceDefinition.pathElement("*");
    private final FunctionExecutorRegistry<Singleton> executors;

    static PathElement pathElement(ServiceName name) {
        return SingletonServiceResourceDefinition.pathElement(name.getCanonicalName());
    }

    static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"service", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        if (SingletonModel.VERSION_3_0_0.requiresTransformation(version)) {
            parent.discardChildResource(WILDCARD_PATH);
        }
    }

    public SingletonServiceResourceDefinition(FunctionExecutorRegistry<Singleton> executors) {
        super(new SimpleResourceDefinition.Parameters(WILDCARD_PATH, SingletonExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{WILDCARD_PATH})).setRuntime());
        this.executors = executors;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        new MetricHandler((MetricExecutor)new SingletonServiceMetricExecutor(this.executors), SingletonMetric.class).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        return registration;
    }
}

