/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import java.util.HashMap;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.functional.impl.Params;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.xsite.BaseBackupInterceptor;
import org.infinispan.marshall.core.MarshallableFunctions;

public class NonTransactionalBackupInterceptor
extends BaseBackupInterceptor {
    private final InvocationSuccessFunction<DataWriteCommand> handleSingleKeyWriteReturn = this::handleSingleKeyWriteReturn;
    private final InvocationSuccessFunction<WriteCommand> handleMultipleKeysWriteReturn = this::handleMultipleKeysWriteReturn;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    InternalEntryFactory internalEntryFactory;

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
        return this.handleMultipleKeysWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) {
        return this.handleMultipleKeysWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) {
        return this.handleMultipleKeysWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) {
        return this.handleMultipleKeysWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        return this.handleMultipleKeysWriteCommand(ctx, command);
    }

    private Object handleSingleKeyWriteCommand(InvocationContext ctx, DataWriteCommand command) {
        if (NonTransactionalBackupInterceptor.skipXSiteBackup(command)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, this.handleSingleKeyWriteReturn);
    }

    private Object handleSingleKeyWriteReturn(InvocationContext ctx, DataWriteCommand dataWriteCommand, Object rv) {
        if (!dataWriteCommand.isSuccessful()) {
            if (trace) {
                log.tracef("Command %s is not successful, not replicating", dataWriteCommand);
            }
            return rv;
        }
        int segment = dataWriteCommand.getSegment();
        DistributionInfo dInfo = this.clusteringDependentLogic.getCacheTopology().getSegmentDistribution(segment);
        if (dInfo.isWriteOwner()) {
            this.iracManager.trackUpdatedKey(dataWriteCommand.getKey(), dataWriteCommand.getCommandInvocationId());
        }
        if (dInfo.isPrimary()) {
            CacheEntry entry = ctx.lookupEntry(dataWriteCommand.getKey());
            WriteCommand crossSiteCommand = this.createCommandForXSite(entry, segment, dataWriteCommand.getFlagsBitSet());
            return this.backupSender.backupWrite(crossSiteCommand, dataWriteCommand).thenReturn(ctx, dataWriteCommand, rv);
        }
        return rv;
    }

    private WriteCommand createCommandForXSite(CacheEntry<?, ?> entry, int segment, long flagsBitSet) {
        return entry.isRemoved() ? this.commandsFactory.buildRemoveCommand(entry.getKey(), null, segment, flagsBitSet) : this.commandsFactory.buildPutKeyValueCommand(entry.getKey(), entry.getValue(), segment, entry.getMetadata(), flagsBitSet);
    }

    private Object handleMultipleKeysWriteCommand(InvocationContext ctx, WriteCommand command) {
        if (trace) {
            log.tracef("Processing %s", command);
        }
        if (NonTransactionalBackupInterceptor.skipXSiteBackup(command)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, this.handleMultipleKeysWriteReturn);
    }

    private Object handleMultipleKeysWriteReturn(InvocationContext ctx, WriteCommand writeCommand, Object rv) {
        if (trace) {
            log.tracef("Processing post %s", writeCommand);
        }
        if (!writeCommand.isSuccessful()) {
            if (trace) {
                log.tracef("Command %s is not successful, not replicating", writeCommand);
            }
            return rv;
        }
        HashMap map = new HashMap();
        LocalizedCacheTopology localizedCacheTopology = this.clusteringDependentLogic.getCacheTopology();
        for (Object key : writeCommand.getAffectedKeys()) {
            DistributionInfo info = localizedCacheTopology.getDistribution(key);
            if (info.isWriteOwner()) {
                this.iracManager.trackUpdatedKey(key, writeCommand.getCommandInvocationId());
            }
            if (!info.isPrimary()) {
                if (!trace) continue;
                log.tracef("Not replicating write to key %s as the primary owner is %s", key, info.primary());
                continue;
            }
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry instanceof InternalCacheEntry) {
                map.put(key, ((InternalCacheEntry)entry).toInternalCacheValue());
                continue;
            }
            map.put(key, this.internalEntryFactory.createValue(entry));
        }
        if (map.isEmpty()) {
            return rv;
        }
        WriteOnlyManyEntriesCommand crossSiteCommand = this.commandsFactory.buildWriteOnlyManyEntriesCommand(map, MarshallableFunctions.setInternalCacheValueConsumer(), Params.fromFlagsBitSet(writeCommand.getFlagsBitSet()), DataConversion.IDENTITY_KEY, DataConversion.IDENTITY_VALUE);
        return this.backupSender.backupWrite(crossSiteCommand, writeCommand).thenReturn(ctx, writeCommand, rv);
    }
}

