/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.elementdesc.adapter.cdi;

import io.smallrye.metrics.elementdesc.AnnotationInfo;
import io.smallrye.metrics.elementdesc.MemberInfo;
import io.smallrye.metrics.elementdesc.MemberType;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIAnnotationInfoAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Objects;

public class CDIMemberInfo
implements MemberInfo {
    private final Object input;

    <T extends Member & AnnotatedElement> CDIMemberInfo(T input) {
        this.input = input;
    }

    @Override
    public MemberType getMemberType() {
        if (this.input instanceof Constructor) {
            return MemberType.CONSTRUCTOR;
        }
        if (this.input instanceof Method) {
            return MemberType.METHOD;
        }
        if (this.input instanceof Field) {
            return MemberType.FIELD;
        }
        throw new Error("Unknown/unsupported member type");
    }

    @Override
    public String getDeclaringClassName() {
        return ((Member)this.input).getDeclaringClass().getName();
    }

    @Override
    public String getDeclaringClassSimpleName() {
        return ((Member)this.input).getDeclaringClass().getSimpleName();
    }

    @Override
    public String getName() {
        return ((Member)this.input).getName();
    }

    public <X extends Annotation> boolean isAnnotationPresent(Class<X> metric) {
        return ((AnnotatedElement)this.input).isAnnotationPresent(metric);
    }

    public <X extends Annotation> AnnotationInfo getAnnotation(Class<X> metric) {
        X annotation = ((AnnotatedElement)this.input).getAnnotation(metric);
        if (annotation != null) {
            return new CDIAnnotationInfoAdapter().convert((Annotation)annotation);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MemberInfo)) {
            return false;
        }
        MemberInfo other = (MemberInfo)obj;
        return other.getDeclaringClassName().equals(this.getDeclaringClassName()) && other.getName().equals(this.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getDeclaringClassName(), this.getName());
    }

    public String toString() {
        return this.input.toString();
    }
}

