/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
    }

    static Field getDeclaredField(final Class<?> c, final String name) throws NoSuchFieldException {
        if (System.getSecurityManager() == null) {
            return c.getDeclaredField(name);
        }
        Field result = AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    return c.getDeclaredField(name);
                }
                catch (NoSuchFieldException e) {
                    return null;
                }
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchFieldException();
    }

    static Method getDeclaredMethod(final Class<?> c, final String name, final Class<?> ... params) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return c.getDeclaredMethod(name, params);
        }
        Method result = AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return c.getDeclaredMethod(name, params);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchMethodException();
    }
}

