/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.logging.Logger;
import org.w3c.dom.Node;

public class SAAJHelper {
    private static boolean isSAAJ14 = false;
    private static Logger log = Logger.getLogger(SAAJHelper.class);
    private static final ClassValue<Method> GET_DOM_ELEMENTS_METHODS;

    public static Node getDomElement(Node node) throws Exception {
        Method method;
        if (node != null && isSAAJ14 && (method = GET_DOM_ELEMENTS_METHODS.get(node.getClass())) != null) {
            try {
                return (Node)SAAJHelper.setAccessible(method).invoke((Object)node, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return node;
    }

    private static <T extends AccessibleObject> T setAccessible(final T o) {
        return (T)((AccessibleObject)AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                o.setAccessible(true);
                return o;
            }
        }));
    }

    private static Method getMethod(final Class<?> clazz, final String name, final Class<?> ... parameterTypes) throws NoSuchMethodException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    return clazz.getMethod(name, parameterTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)e;
            }
            throw new SecurityException(e);
        }
    }

    static {
        try {
            Method[] methods;
            for (Method method : methods = SAAJHelper.class.getClassLoader().loadClass("com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl").getMethods()) {
                if (!method.getName().equals("register")) continue;
                isSAAJ14 = true;
                break;
            }
        }
        catch (ClassNotFoundException cnfe) {
            log.debug((Object)"Can't load class com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl", (Throwable)cnfe);
            try {
                Method[] methods;
                for (Method method : methods = SAAJHelper.class.getClassLoader().loadClass("com.sun.xml.internal.messaging.saaj.soap.SOAPDocumentImpl").getMethods()) {
                    if (!method.getName().equals("register")) continue;
                    isSAAJ14 = true;
                }
            }
            catch (ClassNotFoundException cnfe1) {
                log.debug((Object)"can't load class com.sun.xml.internal.messaging.saaj.soap.SOAPDocumentImpl", (Throwable)cnfe1);
            }
        }
        GET_DOM_ELEMENTS_METHODS = new ClassValue<Method>(){

            @Override
            protected Method computeValue(Class<?> type) {
                try {
                    return SAAJHelper.getMethod(type, "getDomElement", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        };
    }
}

