/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.writers;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v2.util.StaxWriterUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.BaseIDAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.picketlink.identity.federation.saml.v2.assertion.KeyInfoConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.metadata.LocalizedNameType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;

public class BaseWriter {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected static String PROTOCOL_PREFIX = "samlp";
    protected static String ASSERTION_PREFIX = "saml";
    protected static String XACML_SAML_PREFIX = "xacml-saml";
    protected static String XACML_SAML_PROTO_PREFIX = "xacml-samlp";
    protected static String XSI_PREFIX = "xsi";
    protected XMLStreamWriter writer = null;

    public BaseWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void write(NameIDType nameIDType, QName tag) throws ProcessingException {
        String value;
        String nameQualifier;
        String spNameQualifier;
        String spProvidedID;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)tag.getPrefix(), (String)tag.getLocalPart(), (String)tag.getNamespaceURI());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        URI format = nameIDType.getFormat();
        if (format != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.FORMAT.get(), (String)format.toASCIIString());
        }
        if (StringUtil.isNotNull((String)(spProvidedID = nameIDType.getSPProvidedID()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.SP_PROVIDED_ID.get(), (String)spProvidedID);
        }
        if (StringUtil.isNotNull((String)(spNameQualifier = nameIDType.getSPNameQualifier()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.SP_NAME_QUALIFIER.get(), (String)spNameQualifier);
        }
        if (StringUtil.isNotNull((String)(nameQualifier = nameIDType.getNameQualifier()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.NAME_QUALIFIER.get(), (String)nameQualifier);
        }
        if (StringUtil.isNotNull((String)(value = nameIDType.getValue()))) {
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)value);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void write(AttributeType attributeType) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.ATTRIBUTE.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        this.writeAttributeTypeWithoutRootTag(attributeType);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeAttributeTypeWithoutRootTag(AttributeType attributeType) throws ProcessingException {
        List<Object> attributeValues;
        Map<QName, String> otherAttribs;
        String nameFormat;
        String friendlyName;
        String attributeName = attributeType.getName();
        if (attributeName != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.NAME.get(), (String)attributeName);
        }
        if (StringUtil.isNotNull((String)(friendlyName = attributeType.getFriendlyName()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.FRIENDLY_NAME.get(), (String)friendlyName);
        }
        if (StringUtil.isNotNull((String)(nameFormat = attributeType.getNameFormat()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.NAME_FORMAT.get(), (String)nameFormat);
        }
        if ((otherAttribs = attributeType.getOtherAttributes()) != null) {
            ArrayList<String> nameSpacesDealt = new ArrayList<String>();
            Iterator<QName> keySet = otherAttribs.keySet().iterator();
            while (keySet != null && keySet.hasNext()) {
                QName qname = keySet.next();
                String ns = qname.getNamespaceURI();
                if (!nameSpacesDealt.contains(ns)) {
                    StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)qname.getPrefix(), (String)ns);
                    nameSpacesDealt.add(ns);
                }
                String attribValue = otherAttribs.get(qname);
                StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)qname, (String)attribValue);
            }
        }
        if ((attributeValues = attributeType.getAttributeValue()) != null) {
            for (Object attributeValue : attributeValues) {
                if (attributeValue == null) continue;
                if (attributeValue instanceof String) {
                    this.writeStringAttributeValue((String)attributeValue);
                    continue;
                }
                if (attributeValue instanceof List) {
                    List value = (List)attributeValue;
                    Iterator attrValIterator = value.iterator();
                    while (attrValIterator.hasNext()) {
                        this.writeStringAttributeValue((String)attrValIterator.next());
                    }
                    continue;
                }
                throw logger.writerUnsupportedAttributeValueError(attributeValue.getClass().getName());
            }
        }
    }

    public void writeStringAttributeValue(String attributeValue) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.ATTRIBUTE_VALUE.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)JBossSAMLURIConstants.XSI_PREFIX.get(), (String)JBossSAMLURIConstants.XSI_NSURI.get());
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"xs", (String)JBossSAMLURIConstants.XMLSCHEMA_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"xsi", (String)JBossSAMLURIConstants.XSI_NSURI.get(), (String)"type", (String)"xs:string");
        StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)attributeValue);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    public void writeLocalizedNameType(LocalizedNameType localizedNameType, QName startElement) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)startElement.getPrefix(), (String)startElement.getLocalPart(), (String)startElement.getNamespaceURI());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)new QName(JBossSAMLURIConstants.XML.get(), "lang", "xml"), (String)localizedNameType.getLang());
        StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)localizedNameType.getValue());
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    public void write(SubjectType subject) throws ProcessingException {
        List<SubjectConfirmationType> subjectConfirmations;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.SUBJECT.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        SubjectType.STSubType subType = subject.getSubType();
        if (subType != null) {
            EncryptedElementType enc;
            BaseIDAbstractType baseID = subType.getBaseID();
            if (baseID instanceof NameIDType) {
                NameIDType nameIDType = (NameIDType)baseID;
                this.write(nameIDType, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.NAMEID.get(), ASSERTION_PREFIX));
            }
            if ((enc = subType.getEncryptedID()) != null) {
                throw new RuntimeException("NYI");
            }
            List<SubjectConfirmationType> confirmations = subType.getConfirmation();
            if (confirmations != null) {
                for (SubjectConfirmationType confirmation : confirmations) {
                    this.write(confirmation);
                }
            }
        }
        if ((subjectConfirmations = subject.getConfirmation()) != null) {
            for (SubjectConfirmationType subjectConfirmationType : subjectConfirmations) {
                this.write(subjectConfirmationType);
            }
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    private void write(SubjectConfirmationType subjectConfirmationType) throws ProcessingException {
        SubjectConfirmationDataType subjectConfirmationData;
        NameIDType nameIDType;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.SUBJECT_CONFIRMATION.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.METHOD.get(), (String)subjectConfirmationType.getMethod());
        BaseIDAbstractType baseID = subjectConfirmationType.getBaseID();
        if (baseID != null) {
            this.write(baseID);
        }
        if ((nameIDType = subjectConfirmationType.getNameID()) != null) {
            this.write(nameIDType, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.NAMEID.get(), ASSERTION_PREFIX));
        }
        if ((subjectConfirmationData = subjectConfirmationType.getSubjectConfirmationData()) != null) {
            this.write(subjectConfirmationData);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
    }

    private void write(SubjectConfirmationDataType subjectConfirmationData) throws ProcessingException {
        String address;
        String recipient;
        XMLGregorianCalendar notOnOrAfter;
        XMLGregorianCalendar notBefore;
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)ASSERTION_PREFIX, (String)JBossSAMLConstants.SUBJECT_CONFIRMATION_DATA.get(), (String)JBossSAMLURIConstants.ASSERTION_NSURI.get());
        String inResponseTo = subjectConfirmationData.getInResponseTo();
        if (StringUtil.isNotNull((String)inResponseTo)) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.IN_RESPONSE_TO.get(), (String)inResponseTo);
        }
        if ((notBefore = subjectConfirmationData.getNotBefore()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.NOT_BEFORE.get(), (String)notBefore.toString());
        }
        if ((notOnOrAfter = subjectConfirmationData.getNotOnOrAfter()) != null) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.NOT_ON_OR_AFTER.get(), (String)notOnOrAfter.toString());
        }
        if (StringUtil.isNotNull((String)(recipient = subjectConfirmationData.getRecipient()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.RECIPIENT.get(), (String)recipient);
        }
        if (StringUtil.isNotNull((String)(address = subjectConfirmationData.getAddress()))) {
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)JBossSAMLConstants.ADDRESS.get(), (String)address);
        }
        if (subjectConfirmationData instanceof KeyInfoConfirmationDataType) {
            KeyInfoConfirmationDataType kicd = (KeyInfoConfirmationDataType)subjectConfirmationData;
            KeyInfoType keyInfo = (KeyInfoType)kicd.getAnyType();
            StaxWriterUtil.writeKeyInfo(this.writer, keyInfo);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    private void write(BaseIDAbstractType baseId) throws ProcessingException {
        throw logger.notImplementedYet("Method not implemented.");
    }
}

