/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.undertow_httpspi;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.HeaderValues;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.spi.http.HttpContext;
import javax.xml.ws.spi.http.HttpExchange;
import org.jboss.ws.undertow_httpspi.PathUtils;
import org.jboss.ws.undertow_httpspi.UndertowHeaderMap;
import org.jboss.ws.undertow_httpspi.UndertowHttpContext;

public class UndertowHttpExchange
extends HttpExchange {
    private final HttpServerExchange undertowExchange;
    private UndertowHttpContext context;

    public UndertowHttpExchange(HttpServerExchange serverExchange) {
        this.undertowExchange = serverExchange;
    }

    public Map<String, List<String>> getRequestHeaders() {
        return new UndertowHeaderMap(this.undertowExchange.getRequestHeaders());
    }

    public String getRequestHeader(String name) {
        HeaderValues headerValues = this.undertowExchange.getRequestHeaders().get(name);
        if (headerValues != null && headerValues.size() > 0) {
            String result = "";
            for (String headerValue : headerValues) {
                result = result + headerValue;
            }
            return result;
        }
        return null;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return new UndertowHeaderMap(this.undertowExchange.getResponseHeaders());
    }

    public void addResponseHeader(String name, String value) {
        this.undertowExchange.getResponseHeaders().add(new HttpString(name), value);
    }

    public String getRequestURI() {
        return this.undertowExchange.getRequestURI();
    }

    public String getContextPath() {
        return PathUtils.getContextPathFromRequest(this.undertowExchange.getRequestPath());
    }

    public String getRequestMethod() {
        return this.undertowExchange.getRequestMethod().toString();
    }

    public HttpContext getHttpContext() {
        if (this.context == null) {
            this.context = new UndertowHttpContext(new PathHandler(), PathUtils.getContextPathFromRequest(this.undertowExchange.getRequestPath()), PathUtils.getPathFromRequest(this.undertowExchange.getRequestPath()));
        }
        return this.context;
    }

    public void close() throws IOException {
        this.undertowExchange.endExchange();
    }

    public InputStream getRequestBody() throws IOException {
        return this.undertowExchange.getInputStream();
    }

    public OutputStream getResponseBody() throws IOException {
        return this.undertowExchange.getOutputStream();
    }

    public void setStatus(int status) {
        this.undertowExchange.setResponseCode(status);
    }

    public InetSocketAddress getRemoteAddress() {
        return this.undertowExchange.getSourceAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.undertowExchange.getDestinationAddress();
    }

    public String getProtocol() {
        return this.undertowExchange.getProtocol().toString();
    }

    public String getScheme() {
        return this.undertowExchange.getRequestScheme();
    }

    public String getPathInfo() {
        return this.undertowExchange.getRequestPath();
    }

    public String getQueryString() {
        return this.undertowExchange.getQueryString();
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Set<String> getAttributeNames() {
        return null;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }
}

