/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.lang.model.type.MirroredTypeException;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoMessage;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.ProtoUnknownFieldSet;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoFieldMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.ReservedProcessor;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XConstructor;
import org.infinispan.protostream.annotations.impl.types.XExecutable;
import org.infinispan.protostream.annotations.impl.types.XField;
import org.infinispan.protostream.annotations.impl.types.XMember;
import org.infinispan.protostream.annotations.impl.types.XMethod;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.Log;

public final class ProtoMessageTypeMetadata
extends ProtoTypeMetadata {
    private static final Log log = Log.LogFactory.getLog(ProtoMessageTypeMetadata.class);
    private final BaseProtoSchemaGenerator protoSchemaGenerator;
    private final XTypeFactory typeFactory;
    private SortedMap<Integer, ProtoFieldMetadata> fieldsByNumber = null;
    private Map<String, ProtoFieldMetadata> fieldsByName = null;
    private XExecutable factory;
    private XField unknownFieldSetField;
    private XMethod unknownFieldSetGetter;
    private XMethod unknownFieldSetSetter;
    private final Map<XClass, ProtoTypeMetadata> innerTypes = new HashMap<XClass, ProtoTypeMetadata>();

    ProtoMessageTypeMetadata(BaseProtoSchemaGenerator protoSchemaGenerator, XClass messageClass) {
        super(ProtoMessageTypeMetadata.getProtoName(messageClass), messageClass);
        this.protoSchemaGenerator = protoSchemaGenerator;
        this.typeFactory = messageClass.getFactory();
        this.checkInstantiability();
    }

    private static String getProtoName(XClass messageClass) {
        ProtoName annotation = messageClass.getAnnotation(ProtoName.class);
        ProtoMessage protoMessageAnnotation = messageClass.getAnnotation(ProtoMessage.class);
        if (annotation != null) {
            if (protoMessageAnnotation != null) {
                throw new ProtoSchemaBuilderException("@ProtoMessage annotation cannot be used together with @ProtoName: " + messageClass.getName());
            }
            return annotation.value().isEmpty() ? messageClass.getSimpleName() : annotation.value();
        }
        return protoMessageAnnotation == null || protoMessageAnnotation.name().isEmpty() ? messageClass.getSimpleName() : protoMessageAnnotation.name();
    }

    public XExecutable getFactory() {
        this.scanMemberAnnotations();
        return this.factory;
    }

    public XField getUnknownFieldSetField() {
        this.scanMemberAnnotations();
        return this.unknownFieldSetField;
    }

    public XMethod getUnknownFieldSetGetter() {
        this.scanMemberAnnotations();
        return this.unknownFieldSetGetter;
    }

    public XMethod getUnknownFieldSetSetter() {
        this.scanMemberAnnotations();
        return this.unknownFieldSetSetter;
    }

    public SortedMap<Integer, ProtoFieldMetadata> getFields() {
        this.scanMemberAnnotations();
        return this.fieldsByNumber;
    }

    protected void addInnerType(ProtoTypeMetadata typeMetadata) {
        this.innerTypes.put(typeMetadata.getJavaClass(), typeMetadata);
    }

    @Override
    public void generateProto(IndentWriter iw) {
        this.scanMemberAnnotations();
        iw.append("\n\n");
        ProtoMessageTypeMetadata.appendDocumentation(iw, this.getDocumentation());
        iw.append("message ").append(this.name);
        if (BaseProtoSchemaGenerator.generateSchemaDebugComments) {
            iw.append(" /* ").append(this.getJavaClassName()).append(" */");
        }
        iw.append(" {\n");
        iw.inc();
        ReservedProcessor reserved = new ReservedProcessor();
        reserved.scan(this.javaClass);
        Iterator<Object> iterator = this.fieldsByNumber.keySet().iterator();
        while (iterator.hasNext()) {
            int memberNumber = iterator.next();
            ProtoFieldMetadata field = (ProtoFieldMetadata)this.fieldsByNumber.get(memberNumber);
            XClass where = reserved.checkReserved(memberNumber);
            if (where != null) {
                throw new ProtoSchemaBuilderException("Protobuf field number " + memberNumber + " of field " + field.getLocation() + " conflicts with 'reserved' statement in " + where.getCanonicalName());
            }
            where = reserved.checkReserved(field.getName());
            if (where == null) continue;
            throw new ProtoSchemaBuilderException("Protobuf field number " + memberNumber + " of field " + field.getLocation() + " conflicts with 'reserved' statement in " + where.getCanonicalName());
        }
        reserved.generate(iw);
        for (ProtoTypeMetadata t : this.innerTypes.values()) {
            t.generateProto(iw);
        }
        for (ProtoFieldMetadata f : this.fieldsByNumber.values()) {
            f.generateProto(iw);
        }
        iw.dec();
        iw.append("}\n");
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public ProtoEnumValueMetadata getEnumMemberByName(String name) {
        throw new IllegalStateException(this.javaClass.getCanonicalName() + " is not an enum");
    }

    @Override
    public void scanMemberAnnotations() {
        if (this.fieldsByNumber == null) {
            this.fieldsByNumber = new TreeMap<Integer, ProtoFieldMetadata>();
            this.fieldsByName = new HashMap<String, ProtoFieldMetadata>();
            this.discoverFields(this.javaClass, new HashSet<XClass>());
            if (this.fieldsByNumber.isEmpty()) {
                log.warnf("Class %s does not have any @ProtoField annotated members. The class should be either annotated or it should have a custom marshaller.", this.javaClass.getCanonicalName());
            }
            if (this.factory != null) {
                String[] parameterNames = this.factory.getParameterNames();
                if (parameterNames.length != this.fieldsByNumber.size()) {
                    throw new ProtoSchemaBuilderException("@ProtoFactory annotated static method or constructor signature mismatch. Expected " + this.fieldsByNumber.size() + " parameters but found " + parameterNames.length + " : " + this.factory.toGenericString());
                }
                XClass[] parameterTypes = this.factory.getParameterTypes();
                for (int i = 0; i < parameterNames.length; ++i) {
                    String parameterName = parameterNames[i];
                    ProtoFieldMetadata fieldMetadata = this.getFieldByPropertyName(parameterName);
                    if (fieldMetadata == null) {
                        throw new ProtoSchemaBuilderException("@ProtoFactory annotated static method or constructor signature mismatch. The parameter '" + parameterName + "' does not match any field : " + this.factory.toGenericString());
                    }
                    XClass parameterType = parameterTypes[i];
                    boolean paramTypeMismatch = false;
                    if (fieldMetadata.isArray()) {
                        if (!parameterType.isArray() || parameterType.getComponentType() != fieldMetadata.getJavaType()) {
                            paramTypeMismatch = true;
                        }
                    } else if (fieldMetadata.isRepeated()) {
                        if (!fieldMetadata.getCollectionImplementation().isAssignableTo(parameterType)) {
                            paramTypeMismatch = true;
                        }
                    } else if (fieldMetadata.getJavaType() != parameterType) {
                        paramTypeMismatch = true;
                    }
                    if (!paramTypeMismatch) continue;
                    throw new ProtoSchemaBuilderException("@ProtoFactory annotated static method or constructor signature mismatch: " + this.factory.toGenericString() + ". The parameter '" + parameterName + "' does not match the field definition.");
                }
            }
        }
    }

    private ProtoFieldMetadata getFieldByPropertyName(String propName) {
        for (ProtoFieldMetadata field : this.fieldsByNumber.values()) {
            if (!propName.equals(field.getPropertyName())) continue;
            return field;
        }
        return null;
    }

    private void checkInstantiability() {
        XConstructor ctor;
        if (this.javaClass.isAbstract() || this.javaClass.isInterface()) {
            throw new ProtoSchemaBuilderException("Abstract classes are not allowed: " + this.getJavaClassName());
        }
        if (this.javaClass.isLocal()) {
            throw new ProtoSchemaBuilderException("Local or anonymous classes are not allowed. The class " + this.getJavaClassName() + " must be instantiable using an accessible no-argument constructor.");
        }
        if (this.javaClass.getEnclosingClass() != null && !this.javaClass.isStatic()) {
            throw new ProtoSchemaBuilderException("Non-static inner classes are not allowed. The class " + this.getJavaClassName() + " must be instantiable using an accessible no-argument constructor.");
        }
        for (XConstructor xConstructor : this.javaClass.getDeclaredConstructors()) {
            if (xConstructor.getAnnotation(ProtoFactory.class) == null) continue;
            if (this.factory != null) {
                throw new ProtoSchemaBuilderException("Found more than one @ProtoFactory annotated method / constructor : " + xConstructor);
            }
            if (xConstructor.isPrivate()) {
                throw new ProtoSchemaBuilderException("@ProtoFactory annotated constructor must not be private: " + xConstructor);
            }
            this.factory = xConstructor;
        }
        for (XMethod xMethod : this.javaClass.getDeclaredMethods()) {
            if (xMethod.getAnnotation(ProtoFactory.class) == null) continue;
            if (this.factory != null) {
                throw new ProtoSchemaBuilderException("Found more than one @ProtoFactory annotated method / constructor : " + xMethod);
            }
            if (!xMethod.isStatic()) {
                throw new ProtoSchemaBuilderException("@ProtoFactory annotated method must be static: " + xMethod);
            }
            if (xMethod.isPrivate()) {
                throw new ProtoSchemaBuilderException("@ProtoFactory annotated method must not be private: " + xMethod);
            }
            if (xMethod.getReturnType() != this.javaClass) {
                throw new ProtoSchemaBuilderException("@ProtoFactory annotated method has wrong return type: " + xMethod);
            }
            this.factory = xMethod;
        }
        if (this.factory == null && ((ctor = this.javaClass.getDeclaredConstructor(new XClass[0])) == null || ctor.isPrivate())) {
            throw new ProtoSchemaBuilderException("The class " + this.getJavaClassName() + " must be instantiable using an accessible no-argument constructor.");
        }
    }

    private void discoverFields(XClass clazz, Set<XClass> examinedClasses) {
        if (!examinedClasses.add(clazz)) {
            return;
        }
        if (clazz.getSuperclass() != null) {
            this.discoverFields(clazz.getSuperclass(), examinedClasses);
        }
        for (XClass i : clazz.getInterfaces()) {
            this.discoverFields(i, examinedClasses);
        }
        for (XField xField : clazz.getDeclaredFields()) {
            if (xField.getAnnotation(ProtoUnknownFieldSet.class) != null) {
                if (this.unknownFieldSetField != null || this.unknownFieldSetGetter != null || this.unknownFieldSetSetter != null) {
                    throw new ProtoSchemaBuilderException("The @ProtoUnknownFieldSet annotation should not occur more than once in a class and its superclasses and superinterfaces : " + xField);
                }
                this.unknownFieldSetField = xField;
                continue;
            }
            ProtoField annotation = xField.getAnnotation(ProtoField.class);
            if (annotation == null) continue;
            if (xField.isStatic()) {
                throw new ProtoSchemaBuilderException("Static fields cannot be @ProtoField annotated: " + xField);
            }
            if (this.factory == null && xField.isFinal()) {
                throw new ProtoSchemaBuilderException("Final fields cannot be @ProtoField annotated: " + xField);
            }
            if (xField.isPrivate()) {
                throw new ProtoSchemaBuilderException("Private fields cannot be @ProtoField annotated: " + xField);
            }
            int number = this.getNumber(annotation, xField);
            String fieldName = annotation.name();
            if (fieldName.isEmpty()) {
                fieldName = xField.getName();
            }
            Type protobufType = annotation.type();
            if (xField.getType() == this.typeFactory.fromClass(byte[].class) && protobufType == Type.MESSAGE) {
                protobufType = Type.BYTES;
            }
            boolean isArray = this.isArray(xField.getType(), protobufType);
            boolean isRepeated = this.isRepeated(xField.getType(), protobufType);
            boolean isRequired = annotation.required();
            if (isRepeated && isRequired) {
                throw new ProtoSchemaBuilderException("Repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " cannot be marked required.");
            }
            XClass javaType = this.getJavaTypeFromAnnotation(annotation);
            if (javaType == this.typeFactory.fromClass(Void.TYPE)) {
                XClass xClass = javaType = isRepeated ? xField.determineRepeatedElementType() : xField.getType();
            }
            if (javaType == this.typeFactory.fromClass(byte[].class) && protobufType == Type.MESSAGE) {
                protobufType = Type.BYTES;
            }
            if (!javaType.isArray() && !javaType.isPrimitive() && javaType.isAbstract() && !javaType.isEnum()) {
                throw new ProtoSchemaBuilderException("The type " + javaType.getCanonicalName() + " of field '" + fieldName + "' of " + clazz.getCanonicalName() + " should not be abstract.");
            }
            protobufType = this.getProtobufType(javaType, protobufType);
            Object defaultValue = this.getDefaultValue(clazz, fieldName, javaType, protobufType, annotation.defaultValue());
            if (!isRequired && !isRepeated && javaType.isPrimitive() && defaultValue == null) {
                throw new ProtoSchemaBuilderException("Primitive field '" + fieldName + "' of " + clazz.getCanonicalName() + " is not nullable so it should be either marked required or should have a default value.");
            }
            XClass collectionImplementation = this.getCollectionImplementation(clazz, xField.getType(), this.getCollectionImplementationFromAnnotation(annotation), fieldName, isRepeated);
            if (isArray) {
                collectionImplementation = this.typeFactory.fromClass(ArrayList.class);
            }
            ProtoTypeMetadata protoTypeMetadata = null;
            if (protobufType.getJavaType() == JavaType.ENUM || protobufType.getJavaType() == JavaType.MESSAGE) {
                protoTypeMetadata = this.protoSchemaGenerator.scanAnnotations(javaType);
            }
            ProtoFieldMetadata fieldMetadata = new ProtoFieldMetadata(number, fieldName, javaType, collectionImplementation, protobufType, protoTypeMetadata, isRequired, isRepeated, isArray, defaultValue, xField);
            ProtoFieldMetadata existing = (ProtoFieldMetadata)this.fieldsByNumber.get(number);
            if (existing != null) {
                throw new ProtoSchemaBuilderException("Duplicate field number definition. Found two field definitions with number " + number + ": in " + fieldMetadata.getLocation() + " and in " + existing.getLocation());
            }
            existing = this.fieldsByName.get(fieldMetadata.getName());
            if (existing != null) {
                throw new ProtoSchemaBuilderException("Duplicate field name definition. Found two field definitions with name '" + fieldMetadata.getName() + "': in " + fieldMetadata.getLocation() + " and in " + existing.getLocation());
            }
            this.checkReserved(fieldMetadata);
            this.fieldsByNumber.put(fieldMetadata.getNumber(), fieldMetadata);
            this.fieldsByName.put(fieldName, fieldMetadata);
        }
        for (XMethod xMethod : clazz.getDeclaredMethods()) {
            XClass getterReturnType;
            XMethod getter;
            XMethod setter;
            String propertyName;
            if (xMethod.getAnnotation(ProtoUnknownFieldSet.class) != null) {
                String propertyName2;
                if (this.unknownFieldSetField != null || this.unknownFieldSetGetter != null || this.unknownFieldSetSetter != null) {
                    throw new ProtoSchemaBuilderException("The @ProtoUnknownFieldSet annotation should not occur more than once in a class and its superclasses and superinterfaces : " + xMethod);
                }
                if (xMethod.getReturnType() == this.typeFactory.fromClass(Void.TYPE)) {
                    if (!xMethod.getName().startsWith("set") || xMethod.getName().length() < 4) {
                        throw new ProtoSchemaBuilderException("Illegal setter method signature: " + xMethod);
                    }
                    String propertyName22 = Character.toLowerCase(xMethod.getName().charAt(3)) + xMethod.getName().substring(4);
                    if (xMethod.getParameterTypes().length != 1) {
                        throw new ProtoSchemaBuilderException("Illegal setter method signature: " + xMethod);
                    }
                    this.unknownFieldSetSetter = xMethod;
                    this.unknownFieldSetGetter = this.findGetter(propertyName2, xMethod.getParameterTypes()[0]);
                    continue;
                }
                if (xMethod.getName().startsWith("get") && xMethod.getName().length() >= 4) {
                    propertyName2 = Character.toLowerCase(xMethod.getName().charAt(3)) + xMethod.getName().substring(4);
                } else if (xMethod.getName().startsWith("is") && xMethod.getName().length() >= 3) {
                    propertyName2 = Character.toLowerCase(xMethod.getName().charAt(2)) + xMethod.getName().substring(3);
                } else {
                    throw new ProtoSchemaBuilderException("Illegal getter method signature: " + xMethod);
                }
                this.unknownFieldSetGetter = xMethod;
                this.unknownFieldSetSetter = this.findSetter(propertyName2, this.unknownFieldSetGetter.getReturnType());
                continue;
            }
            ProtoField annotation = xMethod.getAnnotation(ProtoField.class);
            if (annotation == null) continue;
            if (xMethod.isPrivate()) {
                throw new ProtoSchemaBuilderException("Private methods cannot be @ProtoField annotated: " + xMethod);
            }
            if (xMethod.isStatic()) {
                throw new ProtoSchemaBuilderException("Static methods cannot be @ProtoField annotated: " + xMethod);
            }
            if (xMethod.getReturnType() == this.typeFactory.fromClass(Void.TYPE)) {
                propertyName = xMethod.getName().startsWith("set") && xMethod.getName().length() >= 4 ? Character.toLowerCase(xMethod.getName().charAt(3)) + xMethod.getName().substring(4) : xMethod.getName();
                if (xMethod.getParameterTypes().length != 1) {
                    throw new ProtoSchemaBuilderException("Illegal setter method signature: " + xMethod);
                }
                if (this.factory != null) {
                    throw new ProtoSchemaBuilderException("Setter methods should not be annotated with @ProtoField when @ProtoFactory is used by a class: " + xMethod);
                }
                setter = xMethod;
                getter = this.findGetter(propertyName, xMethod.getParameterTypes()[0]);
                getterReturnType = getter.getReturnType();
                if (getterReturnType == this.typeFactory.fromClass(Optional.class)) {
                    getterReturnType = getter.determineOptionalReturnType();
                }
            } else {
                propertyName = xMethod.getName().startsWith("get") && xMethod.getName().length() >= 4 ? Character.toLowerCase(xMethod.getName().charAt(3)) + xMethod.getName().substring(4) : (xMethod.getName().startsWith("is") && xMethod.getName().length() >= 3 ? Character.toLowerCase(xMethod.getName().charAt(2)) + xMethod.getName().substring(3) : xMethod.getName());
                getter = xMethod;
                getterReturnType = getter.getReturnType();
                if (getterReturnType == this.typeFactory.fromClass(Optional.class)) {
                    getterReturnType = getter.determineOptionalReturnType();
                }
                setter = this.factory == null ? this.findSetter(propertyName, getterReturnType) : null;
            }
            int number = this.getNumber(annotation, xMethod);
            String fieldName = annotation.name();
            if (fieldName.isEmpty()) {
                fieldName = propertyName;
            }
            Type protobufType = annotation.type();
            if (getterReturnType == this.typeFactory.fromClass(byte[].class) && protobufType == Type.MESSAGE) {
                protobufType = Type.BYTES;
            }
            boolean isArray = this.isArray(getterReturnType, protobufType);
            boolean isRepeated = this.isRepeated(getterReturnType, protobufType);
            boolean isRequired = annotation.required();
            if (isRepeated && isRequired) {
                throw new ProtoSchemaBuilderException("Repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " cannot be marked required.");
            }
            XClass javaType = this.getJavaTypeFromAnnotation(annotation);
            if (javaType == this.typeFactory.fromClass(Void.TYPE)) {
                XClass xClass = javaType = isRepeated ? getter.determineRepeatedElementType() : getterReturnType;
            }
            if (javaType == this.typeFactory.fromClass(byte[].class) && protobufType == Type.MESSAGE) {
                protobufType = Type.BYTES;
            }
            if (!javaType.isArray() && !javaType.isPrimitive() && javaType.isAbstract() && !javaType.isEnum()) {
                throw new ProtoSchemaBuilderException("The type " + javaType.getCanonicalName() + " of field '" + fieldName + "' of " + clazz.getCanonicalName() + " should not be abstract.");
            }
            protobufType = this.getProtobufType(javaType, protobufType);
            Object defaultValue = this.getDefaultValue(clazz, fieldName, javaType, protobufType, annotation.defaultValue());
            if (!isRequired && !isRepeated && javaType.isPrimitive() && defaultValue == null) {
                throw new ProtoSchemaBuilderException("Primitive field '" + fieldName + "' of " + clazz.getCanonicalName() + " is not nullable so it should be either marked required or should have a default value.");
            }
            XClass collectionImplementation = this.getCollectionImplementation(clazz, getterReturnType, this.getCollectionImplementationFromAnnotation(annotation), fieldName, isRepeated);
            if (isArray) {
                collectionImplementation = this.typeFactory.fromClass(ArrayList.class);
            }
            ProtoTypeMetadata protoTypeMetadata = null;
            if (protobufType.getJavaType() == JavaType.ENUM || protobufType.getJavaType() == JavaType.MESSAGE) {
                protoTypeMetadata = this.protoSchemaGenerator.scanAnnotations(javaType);
            }
            ProtoFieldMetadata fieldMetadata = new ProtoFieldMetadata(number, fieldName, javaType, collectionImplementation, protobufType, protoTypeMetadata, isRequired, isRepeated, isArray, defaultValue, propertyName, xMethod, getter, setter);
            ProtoFieldMetadata existing = (ProtoFieldMetadata)this.fieldsByNumber.get(number);
            if (existing != null) {
                throw new ProtoSchemaBuilderException("Duplicate field definition. Found two field definitions with number " + number + ": in " + fieldMetadata.getLocation() + " and in " + existing.getLocation());
            }
            existing = this.fieldsByName.get(fieldMetadata.getName());
            if (existing != null) {
                throw new ProtoSchemaBuilderException("Duplicate field definition. Found two field definitions with name '" + fieldMetadata.getName() + "': in " + fieldMetadata.getLocation() + " and in " + existing.getLocation());
            }
            this.checkReserved(fieldMetadata);
            this.fieldsByNumber.put(number, fieldMetadata);
            this.fieldsByName.put(fieldName, fieldMetadata);
        }
    }

    private int getNumber(ProtoField annotation, XMember member) {
        int number = annotation.number();
        if (number == 0) {
            number = annotation.value();
        } else if (annotation.value() != 0) {
            throw new ProtoSchemaBuilderException("@ProtoField.number() and value() are mutually exclusive: " + member);
        }
        if (number < 1) {
            throw new ProtoSchemaBuilderException("Protobuf field numbers specified by @ProtoField.number() or value() must be greater than 0: " + member);
        }
        return number;
    }

    private void checkReserved(ProtoFieldMetadata fieldMetadata) {
        if (fieldMetadata.getNumber() >= 19000 && fieldMetadata.getNumber() <= 19999) {
            throw new ProtoSchemaBuilderException("Protobuf field numbers 19000 through 19999 are reserved for internal use: " + fieldMetadata.getLocation());
        }
    }

    private XClass getCollectionImplementationFromAnnotation(ProtoField annotation) {
        try {
            return this.typeFactory.fromClass(annotation.collectionImplementation());
        }
        catch (MirroredTypeException e) {
            return this.typeFactory.fromTypeMirror(e.getTypeMirror());
        }
    }

    private XClass getJavaTypeFromAnnotation(ProtoField annotation) {
        try {
            return this.typeFactory.fromClass(annotation.javaType());
        }
        catch (MirroredTypeException e) {
            return this.typeFactory.fromTypeMirror(e.getTypeMirror());
        }
    }

    private Object getDefaultValue(XClass clazz, String fieldName, XClass fieldType, Type protobufType, String defaultValue) {
        if (defaultValue == null || defaultValue.isEmpty()) {
            return null;
        }
        if (fieldType == this.typeFactory.fromClass(String.class)) {
            return defaultValue;
        }
        if (fieldType.isEnum()) {
            ProtoTypeMetadata protoEnumTypeMetadata = this.protoSchemaGenerator.scanAnnotations(fieldType);
            ProtoEnumValueMetadata enumVal = protoEnumTypeMetadata.getEnumMemberByName(defaultValue);
            if (enumVal == null) {
                throw new ProtoSchemaBuilderException("Invalid default value for field '" + fieldName + "' of Java type " + fieldType.getCanonicalName() + " from class " + clazz.getCanonicalName() + ": " + defaultValue + " is not a member of " + protoEnumTypeMetadata.getFullName() + " enum");
            }
            return enumVal;
        }
        if (fieldType == this.typeFactory.fromClass(Character.class) || fieldType == this.typeFactory.fromClass(Character.TYPE)) {
            if (defaultValue.length() > 1) {
                throw new ProtoSchemaBuilderException("Invalid default value for field '" + fieldName + "' of Java type " + fieldType.getCanonicalName() + " from class " + clazz.getCanonicalName() + ": " + defaultValue);
            }
            return Character.valueOf(defaultValue.charAt(0));
        }
        if (fieldType == this.typeFactory.fromClass(Boolean.class) || fieldType == this.typeFactory.fromClass(Boolean.TYPE)) {
            return Boolean.valueOf(defaultValue);
        }
        try {
            if (fieldType == this.typeFactory.fromClass(Integer.class) || fieldType == this.typeFactory.fromClass(Integer.TYPE)) {
                int v = this.parseInt(defaultValue);
                if (v < 0 && protobufType.isUnsigned()) {
                    throw new ProtoSchemaBuilderException("Field '" + fieldName + "' of unsigned Protobuf type " + (Object)((Object)protobufType) + " from class " + clazz.getCanonicalName() + " does not allow a negative default value : " + defaultValue);
                }
                return v;
            }
            if (fieldType == this.typeFactory.fromClass(Long.class) || fieldType == this.typeFactory.fromClass(Long.TYPE)) {
                long v = this.parseLong(defaultValue);
                if (v < 0L && protobufType.isUnsigned()) {
                    throw new ProtoSchemaBuilderException("Field '" + fieldName + "' of unsigned Protobuf type " + (Object)((Object)protobufType) + " from class " + clazz.getCanonicalName() + " does not allow a negative default value : " + defaultValue);
                }
                return v;
            }
            if (fieldType == this.typeFactory.fromClass(Short.class) || fieldType == this.typeFactory.fromClass(Short.TYPE)) {
                int v = this.parseInt(defaultValue);
                if (v < 0 && protobufType.isUnsigned()) {
                    throw new ProtoSchemaBuilderException("Field '" + fieldName + "' of unsigned Protobuf type " + (Object)((Object)protobufType) + " from class " + clazz.getCanonicalName() + " does not allow a negative default value : " + defaultValue);
                }
                if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
                    throw new NumberFormatException("Value out of range for \"" + (Object)((Object)protobufType) + "\": \"" + defaultValue);
                }
                return (short)v;
            }
            if (fieldType == this.typeFactory.fromClass(Double.class) || fieldType == this.typeFactory.fromClass(Double.TYPE)) {
                return Double.valueOf(defaultValue);
            }
            if (fieldType == this.typeFactory.fromClass(Float.class) || fieldType == this.typeFactory.fromClass(Float.TYPE)) {
                return Float.valueOf(defaultValue);
            }
            if (fieldType == this.typeFactory.fromClass(Byte.class) || fieldType == this.typeFactory.fromClass(Byte.TYPE)) {
                int v = this.parseInt(defaultValue);
                if (v < 0 && protobufType.isUnsigned()) {
                    throw new ProtoSchemaBuilderException("Field '" + fieldName + "' of unsigned Protobuf type " + (Object)((Object)protobufType) + " from class " + clazz.getCanonicalName() + " does not allow a negative default value : " + defaultValue);
                }
                if (v < -128 || v > 127) {
                    throw new NumberFormatException("Value out of range for \"" + (Object)((Object)protobufType) + "\": \"" + defaultValue);
                }
                return (byte)v;
            }
            if (fieldType.isAssignableTo(this.typeFactory.fromClass(Date.class))) {
                return Long.parseUnsignedLong(defaultValue);
            }
            if (fieldType.isAssignableTo(this.typeFactory.fromClass(Instant.class))) {
                return Long.parseUnsignedLong(defaultValue);
            }
        }
        catch (NumberFormatException e) {
            throw new ProtoSchemaBuilderException("Invalid default value for field '" + fieldName + "' of Java type " + fieldType.getCanonicalName() + " from class " + clazz.getCanonicalName() + ": " + defaultValue, (Throwable)e);
        }
        if (protobufType == Type.BYTES) {
            if (fieldType == this.typeFactory.fromClass(byte[].class)) {
                return ProtoMessageTypeMetadata.cescape(defaultValue);
            }
            throw new ProtoSchemaBuilderException("Invalid default value for field '" + fieldName + "' of Java type " + fieldType.getCanonicalName() + " from class " + clazz.getCanonicalName() + ": " + defaultValue);
        }
        throw new ProtoSchemaBuilderException("No default value is allowed for field '" + fieldName + "' of Java type " + fieldType.getCanonicalName() + " from class " + clazz.getCanonicalName());
    }

    static byte[] cescape(String s) {
        return ProtoMessageTypeMetadata.cescape(s.getBytes(StandardCharsets.UTF_8));
    }

    static byte[] cescape(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
        for (byte b : bytes) {
            int ub = Byte.toUnsignedInt(b);
            if (ub < 32 || ub > 127) {
                baos.write(92);
                baos.write(48 + (ub >> 6 & 7));
                baos.write(48 + (ub >> 3 & 7));
                baos.write(48 + (ub & 7));
                continue;
            }
            baos.write(ub);
        }
        return baos.toByteArray();
    }

    private long parseLong(String value) {
        int radix;
        if (value == null) {
            throw new IllegalArgumentException("value argument cannot be null");
        }
        if (value.isEmpty()) {
            throw new NumberFormatException("Empty input string");
        }
        String s = value;
        boolean isNegative = false;
        if (s.charAt(0) == '-') {
            isNegative = true;
            s = s.substring(1);
        }
        if (s.length() > 1 && s.charAt(0) == '0') {
            if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                radix = 16;
                s = s.substring(2);
            } else {
                radix = 8;
                s = s.substring(1);
            }
        } else {
            radix = 10;
        }
        try {
            long v = Long.parseUnsignedLong(s, radix);
            return isNegative ? -v : v;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("For input string: \"" + value + "\"");
        }
    }

    private int parseInt(String value) {
        int radix;
        if (value == null) {
            throw new IllegalArgumentException("value argument cannot be null");
        }
        if (value.isEmpty()) {
            throw new NumberFormatException("Empty input string");
        }
        String s = value;
        boolean isNegative = false;
        if (s.charAt(0) == '-') {
            isNegative = true;
            s = s.substring(1);
        }
        if (s.length() > 1 && s.charAt(0) == '0') {
            if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                radix = 16;
                s = s.substring(2);
            } else {
                radix = 8;
                s = s.substring(1);
            }
        } else {
            radix = 10;
        }
        try {
            int v = Integer.parseUnsignedInt(s, radix);
            return isNegative ? -v : v;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("For input string: \"" + value + "\"");
        }
    }

    private XClass getCollectionImplementation(XClass clazz, XClass fieldType, XClass configuredCollection, String fieldName, boolean isRepeated) {
        XClass collectionImplementation;
        XClass javaUtilCollectionClass = this.typeFactory.fromClass(Collection.class);
        if (isRepeated && !fieldType.isArray()) {
            collectionImplementation = configuredCollection;
            if (collectionImplementation == javaUtilCollectionClass) {
                collectionImplementation = fieldType == this.typeFactory.fromClass(Set.class) ? this.typeFactory.fromClass(HashSet.class) : (fieldType == this.typeFactory.fromClass(List.class) || fieldType == this.typeFactory.fromClass(Collection.class) ? this.typeFactory.fromClass(ArrayList.class) : fieldType);
            }
            if (!collectionImplementation.isAssignableTo(javaUtilCollectionClass)) {
                throw new ProtoSchemaBuilderException("The collection class of repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " must implement java.util.Collection.");
            }
            if (collectionImplementation.isAbstract()) {
                throw new ProtoSchemaBuilderException("The collection class (" + collectionImplementation.getCanonicalName() + ") of repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " must not be abstract. Please specify an appropriate class in collectionImplementation member.");
            }
            XConstructor ctor = collectionImplementation.getDeclaredConstructor(new XClass[0]);
            if (ctor == null || ctor.isPrivate()) {
                throw new ProtoSchemaBuilderException("The collection class ('" + collectionImplementation.getCanonicalName() + "') of repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " must have a public no-argument constructor.");
            }
            if (!collectionImplementation.isAssignableTo(fieldType)) {
                throw new ProtoSchemaBuilderException("The collection implementation class ('" + collectionImplementation.getCanonicalName() + "') of repeated field '" + fieldName + "' of " + clazz.getCanonicalName() + " is not assignable to this field's type.");
            }
        } else {
            if (configuredCollection != javaUtilCollectionClass) {
                throw new ProtoSchemaBuilderException("Specifying the collection implementation class is only allowed for collection (repeated) fields: '" + fieldName + "' of " + clazz.getCanonicalName());
            }
            collectionImplementation = null;
        }
        return collectionImplementation;
    }

    private Type getProtobufType(XClass javaType, Type declaredType) {
        switch (declaredType) {
            case MESSAGE: {
                if (javaType.isEnum()) {
                    ProtoTypeMetadata m = this.protoSchemaGenerator.scanAnnotations(javaType);
                    if (!m.isEnum()) {
                        throw new ProtoSchemaBuilderException(javaType.getCanonicalName() + " is not a Protobuf marshallable enum type");
                    }
                    return Type.ENUM;
                }
                if (javaType == this.typeFactory.fromClass(String.class)) {
                    return Type.STRING;
                }
                if (javaType == this.typeFactory.fromClass(Double.class) || javaType == this.typeFactory.fromClass(Double.TYPE)) {
                    return Type.DOUBLE;
                }
                if (javaType == this.typeFactory.fromClass(Float.class) || javaType == this.typeFactory.fromClass(Float.TYPE)) {
                    return Type.FLOAT;
                }
                if (javaType == this.typeFactory.fromClass(Long.class) || javaType == this.typeFactory.fromClass(Long.TYPE)) {
                    return Type.INT64;
                }
                if (javaType == this.typeFactory.fromClass(Integer.class) || javaType == this.typeFactory.fromClass(Integer.TYPE) || javaType == this.typeFactory.fromClass(Short.class) || javaType == this.typeFactory.fromClass(Short.TYPE) || javaType == this.typeFactory.fromClass(Byte.class) || javaType == this.typeFactory.fromClass(Byte.TYPE) || javaType == this.typeFactory.fromClass(Character.class) || javaType == this.typeFactory.fromClass(Character.TYPE)) {
                    return Type.INT32;
                }
                if (javaType == this.typeFactory.fromClass(Boolean.class) || javaType == this.typeFactory.fromClass(Boolean.TYPE)) {
                    return Type.BOOL;
                }
                if (javaType.isAssignableTo(this.typeFactory.fromClass(Date.class))) {
                    return Type.FIXED64;
                }
                if (javaType.isAssignableTo(this.typeFactory.fromClass(Instant.class))) {
                    return Type.FIXED64;
                }
                ProtoTypeMetadata m = this.protoSchemaGenerator.scanAnnotations(javaType);
                if (!m.isEnum()) break;
                throw new ProtoSchemaBuilderException(javaType.getCanonicalName() + " is not a Protobuf marshallable message type");
            }
            case ENUM: {
                if (javaType.isEnum()) break;
                throw new ProtoSchemaBuilderException(javaType.getCanonicalName() + " is not a Protobuf marshallable enum type");
            }
            case GROUP: {
                ProtoTypeMetadata m = this.protoSchemaGenerator.scanAnnotations(javaType);
                if (!m.isEnum()) break;
                throw new ProtoSchemaBuilderException(javaType.getCanonicalName() + " is not a Protobuf marshallable message type");
            }
            case STRING: {
                if (javaType == this.typeFactory.fromClass(String.class)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + (Object)((Object)declaredType));
            }
            case BYTES: {
                if (javaType == this.typeFactory.fromClass(byte[].class)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + (Object)((Object)declaredType));
            }
            case DOUBLE: {
                if (javaType == this.typeFactory.fromClass(Double.class) || javaType == this.typeFactory.fromClass(Double.TYPE)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + (Object)((Object)declaredType));
            }
            case FLOAT: {
                if (javaType == this.typeFactory.fromClass(Float.class) || javaType == this.typeFactory.fromClass(Float.TYPE)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + (Object)((Object)declaredType));
            }
            case BOOL: {
                if (javaType == this.typeFactory.fromClass(Boolean.class) || javaType == this.typeFactory.fromClass(Boolean.TYPE)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + (Object)((Object)declaredType));
            }
            case INT32: 
            case UINT32: 
            case FIXED32: 
            case SFIXED32: 
            case SINT32: {
                if (javaType == this.typeFactory.fromClass(Integer.class) || javaType == this.typeFactory.fromClass(Integer.TYPE) || javaType == this.typeFactory.fromClass(Short.class) || javaType == this.typeFactory.fromClass(Short.TYPE) || javaType == this.typeFactory.fromClass(Byte.class) || javaType == this.typeFactory.fromClass(Byte.TYPE)) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + (Object)((Object)declaredType));
            }
            case INT64: 
            case UINT64: 
            case FIXED64: 
            case SFIXED64: 
            case SINT64: {
                if (javaType == this.typeFactory.fromClass(Long.class) || javaType == this.typeFactory.fromClass(Long.TYPE) || javaType.isAssignableTo(this.typeFactory.fromClass(Date.class)) || javaType.isAssignableTo(this.typeFactory.fromClass(Instant.class))) break;
                throw new ProtoSchemaBuilderException("Incompatible types : " + javaType.getCanonicalName() + " vs " + (Object)((Object)declaredType));
            }
        }
        return declaredType;
    }

    private boolean isArray(XClass javaType, Type type) {
        if (type == Type.BYTES && javaType == this.typeFactory.fromClass(byte[].class)) {
            return false;
        }
        return javaType.isArray();
    }

    private boolean isRepeated(XClass javaType, Type type) {
        if (type == Type.BYTES && javaType == this.typeFactory.fromClass(byte[].class)) {
            return false;
        }
        return javaType.isArray() || javaType.isAssignableTo(this.typeFactory.fromClass(Collection.class));
    }

    private XMethod findGetter(String propertyName, XClass propertyType) {
        boolean isBoolean = propertyType == this.typeFactory.fromClass(Boolean.TYPE) || propertyType == this.typeFactory.fromClass(Boolean.class);
        String methodName = (isBoolean ? "is" : "get") + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        XMethod getter = this.javaClass.getMethod(methodName, new XClass[0]);
        if (getter == null && isBoolean) {
            methodName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            getter = this.javaClass.getMethod(methodName, new XClass[0]);
        }
        if (getter == null) {
            getter = this.javaClass.getMethod(propertyName, new XClass[0]);
        }
        if (getter == null) {
            throw new ProtoSchemaBuilderException("No getter method found for property '" + propertyName + "' of type " + propertyType.getCanonicalName() + " in class " + this.javaClass.getCanonicalName());
        }
        XClass returnType = getter.getReturnType();
        if (returnType == this.typeFactory.fromClass(Optional.class)) {
            returnType = getter.determineOptionalReturnType();
        }
        if (returnType != propertyType) {
            throw new ProtoSchemaBuilderException("No suitable getter method found for property '" + propertyName + "' of type " + propertyType.getCanonicalName() + " in class " + this.javaClass.getCanonicalName() + ". The candidate method does not have a suitable return type: " + getter);
        }
        return getter;
    }

    private XMethod findSetter(String propertyName, XClass propertyType) {
        String methodName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        XMethod setter = this.javaClass.getMethod(methodName, propertyType);
        if (setter == null) {
            setter = this.javaClass.getMethod(propertyName, propertyType);
        }
        if (setter == null) {
            throw new ProtoSchemaBuilderException("No setter method found for property '" + propertyName + "' of type " + propertyType.getCanonicalName() + " in class " + this.javaClass.getCanonicalName());
        }
        if (setter.getReturnType() != this.typeFactory.fromClass(Void.TYPE)) {
            throw new ProtoSchemaBuilderException("No suitable setter method found for property '" + propertyName + "' of type " + propertyType.getCanonicalName() + " in class " + this.javaClass.getCanonicalName() + ". The candidate method does not have a suitable return type: " + setter);
        }
        return setter;
    }

    public String toString() {
        return "ProtoMessageTypeMetadata{name='" + this.name + '\'' + ", javaClass=" + this.javaClass + ", fieldsByNumber=" + this.fieldsByNumber + ", factory=" + this.factory + ", unknownFieldSetField=" + this.unknownFieldSetField + ", unknownFieldSetGetter=" + this.unknownFieldSetGetter + ", unknownFieldSetSetter=" + this.unknownFieldSetSetter + ", innerTypes=" + this.innerTypes + '}';
    }
}

