/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.JGroupsConfiguration;
import org.infinispan.configuration.global.StackBuilder;
import org.infinispan.configuration.global.StackConfiguration;
import org.infinispan.configuration.global.StackConfigurationBuilder;
import org.infinispan.configuration.global.StackFileConfiguration;
import org.infinispan.configuration.global.StackFileConfigurationBuilder;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;

public class JGroupsConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<JGroupsConfiguration> {
    private final AttributeSet attributes;
    private List<StackConfigurationBuilder> stackConfigurationBuilders = new ArrayList<StackConfigurationBuilder>();
    private List<StackFileConfigurationBuilder> stackFileConfigurationBuilders = new ArrayList<StackFileConfigurationBuilder>();
    private Map<String, StackBuilder<?>> buildersByName = new HashMap();

    JGroupsConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
        this.attributes = JGroupsConfiguration.attributeDefinitionSet();
    }

    public void validate() {
        this.stackConfigurationBuilders.forEach(s -> this.validate());
        this.stackFileConfigurationBuilders.forEach(s -> this.validate());
    }

    public StackConfigurationBuilder addStack(String name) {
        StackConfigurationBuilder stackConfigurationBuilder = new StackConfigurationBuilder(name, this.getGlobalConfig());
        this.buildersByName.put(name, stackConfigurationBuilder);
        this.stackConfigurationBuilders.add(stackConfigurationBuilder);
        return stackConfigurationBuilder;
    }

    public StackFileConfigurationBuilder addStackFile(String name) {
        StackFileConfigurationBuilder stackFileConfigurationBuilder = new StackFileConfigurationBuilder(name, this.getGlobalConfig());
        this.stackFileConfigurationBuilders.add(stackFileConfigurationBuilder);
        this.buildersByName.put(name, stackFileConfigurationBuilder);
        return stackFileConfigurationBuilder;
    }

    public JGroupsConfigurationBuilder transport(Transport transport) {
        this.attributes.attribute(JGroupsConfiguration.TRANSPORT).set((Object)transport);
        return this;
    }

    public JGroupsConfigurationBuilder clear() {
        this.stackConfigurationBuilders = new ArrayList<StackConfigurationBuilder>();
        this.stackFileConfigurationBuilders = new ArrayList<StackFileConfigurationBuilder>();
        return this;
    }

    Transport jgroupsTransport() {
        return (Transport)this.attributes.attribute(JGroupsConfiguration.TRANSPORT).get();
    }

    public JGroupsConfiguration create() {
        List<StackFileConfiguration> stackFileConfigurations = this.stackFileConfigurationBuilders.stream().map(StackFileConfigurationBuilder::create).collect(Collectors.toList());
        List<StackConfiguration> stackConfigurations = this.stackConfigurationBuilders.stream().map(StackConfigurationBuilder::create).collect(Collectors.toList());
        return new JGroupsConfiguration(this.attributes.protect(), stackFileConfigurations, stackConfigurations);
    }

    public JGroupsConfigurationBuilder read(JGroupsConfiguration template) {
        this.attributes.read(template.attributes());
        template.stackFiles().forEach(s -> this.stackFileConfigurationBuilders.add(new StackFileConfigurationBuilder(s.name(), this.getGlobalConfig()).read((StackFileConfiguration)s)));
        template.stacks().forEach(s -> this.stackConfigurationBuilders.add(new StackConfigurationBuilder(s.name(), this.getGlobalConfig()).read((StackConfiguration)s)));
        return this;
    }

    public JGroupsChannelConfigurator getStack(String name) {
        StackBuilder<?> stackBuilder = this.buildersByName.get(name);
        return stackBuilder == null ? null : stackBuilder.getConfigurator(name);
    }

    public String toString() {
        return "JGroupsConfigurationBuilder{attributes=" + this.attributes + ", stackConfigurationBuilders=" + this.stackConfigurationBuilders + ", stackFileConfigurationBuilders=" + this.stackFileConfigurationBuilders + '}';
    }
}

