/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.spi.ByteBufferOutputStream;

public class TypedObjectMarshaller
implements ProtoStreamMarshaller<Object> {
    private final ProtoStreamMarshaller<Class<?>> typeMarshaller;

    public TypedObjectMarshaller(ProtoStreamMarshaller<Class<?>> typeMarshaller) {
        this.typeMarshaller = typeMarshaller;
    }

    public Object readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        ByteBuffer buffer = reader.readByteBuffer();
        Class targetClass = (Class)this.typeMarshaller.readFrom(context, reader);
        return ProtobufUtil.fromByteBuffer((ImmutableSerializationContext)context, (ByteBuffer)buffer, (Class)targetClass);
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
        try (ByteBufferOutputStream output = new ByteBufferOutputStream(TypedObjectMarshaller.objectSize(context, value));){
            ProtobufUtil.writeTo((ImmutableSerializationContext)context, (OutputStream)output, (Object)value);
            ByteBuffer buffer = output.getBuffer();
            int offset = buffer.arrayOffset();
            int size = buffer.limit() - offset;
            writer.writeUInt32NoTag(size);
            writer.writeRawBytes(buffer.array(), offset, size);
        }
        this.typeMarshaller.writeTo(context, writer, value.getClass());
    }

    private static OptionalInt objectSize(ImmutableSerializationContext context, Object value) {
        BaseMarshaller marshaller = context.getMarshaller(value.getClass());
        OptionalInt size = marshaller instanceof Predictable ? ((Predictable)marshaller).size(context, value) : OptionalInt.empty();
        return size.isPresent() ? OptionalInt.of(Predictable.byteArraySize(size.getAsInt())) : size;
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, Object value) {
        OptionalInt objectSize = TypedObjectMarshaller.objectSize(context, value);
        OptionalInt typeSize = this.typeMarshaller.size(context, value.getClass());
        return objectSize.isPresent() && typeSize.isPresent() ? OptionalInt.of(objectSize.getAsInt() + typeSize.getAsInt()) : OptionalInt.empty();
    }

    public Class<? extends Object> getJavaClass() {
        return null;
    }
}

