/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSConsumer;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.util.TransactionUtils;

public class JmsConnectionSession
implements Connection,
XAConnection,
Session,
XASession,
QueueConnection,
XAQueueConnection,
TopicConnection,
XATopicConnection,
AutoCloseable {
    private static final Logger log = Logger.getLogger(JmsConnectionSession.class);
    private final Connection connection;
    private final Session session;
    private XAConnection xaConnection;
    private XASession xaSession;

    public JmsConnectionSession(Connection connection, Session session) {
        if (connection == null || session == null) {
            throw new ExceptionInInitializerError("JMS 1.1 Connection and Session both must not be null");
        }
        this.connection = connection;
        this.session = session;
        if (connection instanceof XAConnection) {
            this.xaConnection = (XAConnection)connection;
        }
        if (session instanceof XASession) {
            this.xaSession = (XASession)session;
        }
    }

    public Session getSession() throws JMSException {
        if (this.xaSession == null) {
            throw new JMSException("Not an XA compliant JMS session context");
        }
        return this.xaSession.getSession();
    }

    public XAResource getXAResource() {
        if (this.xaSession == null) {
            throw new IllegalStateException("Not an XA compliant JMS session context");
        }
        return this.xaSession.getXAResource();
    }

    public XASession createXASession() throws JMSException {
        if (this.xaConnection != null) {
            return this.xaConnection.createXASession();
        }
        throw new JMSException("Not an XA compliant JMS session context");
    }

    public BytesMessage createBytesMessage() throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS session context");
        }
        return this.session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS session context");
        }
        return this.session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        if (this.session != null) {
            return this.session.createMessage();
        }
        throw new JMSException("No valid JMS session context");
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS session context");
        }
        return this.session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS session context");
        }
        return this.session.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        if (this.session != null) {
            return this.session.createStreamMessage();
        }
        throw new JMSException("No valid JMS session context");
    }

    public TextMessage createTextMessage() throws JMSException {
        if (this.session != null) {
            return this.session.createTextMessage();
        }
        throw new JMSException("No valid JMS session context");
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        if (this.session != null) {
            return this.session.createTextMessage(text);
        }
        throw new JMSException("No valid JMS session context");
    }

    public boolean getTransacted() throws JMSException {
        if (this.session != null) {
            return this.session.getTransacted();
        }
        throw new JMSException("No valid JMS session context");
    }

    public int getAcknowledgeMode() throws JMSException {
        if (this.session != null) {
            return this.session.getAcknowledgeMode();
        }
        throw new JMSException("No valid JMS session context");
    }

    public void commit() throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS session context");
        }
        this.session.commit();
    }

    public void rollback() throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS session context");
        }
        this.session.rollback();
    }

    public void recover() throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS session context");
        }
        this.session.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new JMSException("Must not be used in a Java EE application");
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        throw new JMSException("Must not be used in a Java EE application");
    }

    public void run() {
        if (this.session == null) {
            throw new IllegalStateException("No valid JMS session context");
        }
        this.session.run();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        if (this.session != null) {
            return this.session.createProducer(destination);
        }
        throw new JMSException("No valid JMS session context");
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        if (this.session != null) {
            return this.session.createConsumer(destination);
        }
        throw new JMSException("No valid JMS session context");
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        if (this.session != null) {
            return this.session.createConsumer(destination, messageSelector);
        }
        throw new JMSException("No valid JMS session context");
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (this.session != null) {
            return this.session.createConsumer(destination, messageSelector, noLocal);
        }
        throw new JMSException("No valid JMS session context");
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        if (this.session != null) {
            return this.session.createSharedConsumer(topic, sharedSubscriptionName);
        }
        throw new JMSException("No valid JMS session context");
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        if (this.session != null) {
            return this.session.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
        }
        throw new JMSException("No valid JMS session context");
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (this.session != null) {
            return this.session.createQueue(queueName);
        }
        throw new JMSException("No valid JMS session context");
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.session != null) {
            return this.session.createTopic(topicName);
        }
        throw new JMSException("No valid JMS session context");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (this.session != null) {
            return this.session.createDurableSubscriber(topic, name);
        }
        throw new JMSException("No valid JMS session context");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (this.session != null) {
            return this.session.createDurableSubscriber(topic, name, messageSelector, noLocal);
        }
        throw new JMSException("No valid JMS session context");
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        if (this.session != null) {
            return this.session.createDurableConsumer(topic, name);
        }
        throw new JMSException("No valid JMS session context");
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (this.session != null) {
            return this.session.createDurableConsumer(topic, name, messageSelector, noLocal);
        }
        throw new JMSException("No valid JMS session context");
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        if (this.session != null) {
            return this.session.createSharedDurableConsumer(topic, name);
        }
        throw new JMSException("No valid JMS session context");
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        if (this.session != null) {
            return this.session.createSharedDurableConsumer(topic, name, messageSelector);
        }
        throw new JMSException("No valid JMS session context");
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (this.session != null) {
            return this.session.createBrowser(queue);
        }
        throw new JMSException("No valid JMS session context");
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (this.session != null) {
            return this.session.createBrowser(queue, messageSelector);
        }
        throw new JMSException("No valid JMS session context");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.session != null) {
            return this.session.createTemporaryQueue();
        }
        throw new JMSException("No valid JMS session context");
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.session != null) {
            return this.session.createTemporaryTopic();
        }
        throw new JMSException("No valid JMS session context");
    }

    public void unsubscribe(String name) throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS session context");
        }
        this.session.unsubscribe(name);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.session != null) {
            if (transacted && this.connection instanceof XAConnection || TransactionUtils.isInTransaction()) {
                log.debug((Object)"Connection is JTA transacted; setting acknowledgeMode to SESSION_TRANSACTED");
                return this.connection.createSession(true, 0);
            }
            log.debug((Object)("Connection is NOT transacted; setting acknowledgeMode=" + acknowledgeMode));
            return this.connection.createSession(false, acknowledgeMode);
        }
        throw new JMSException("No valid JMS connection session");
    }

    public Session createSession(int sessionMode) throws JMSException {
        if (this.session != null) {
            if (sessionMode == 0 && this.connection instanceof XAConnection || TransactionUtils.isInTransaction()) {
                log.debug((Object)"Connection is JTA transacted; setting acknowledgeMode to SESSION_TRANSACTED");
                return this.connection.createSession(0);
            }
            int acknowledgeMode = -1;
            switch (sessionMode) {
                case 0: {
                    acknowledgeMode = 0;
                    break;
                }
                case 1: {
                    acknowledgeMode = 1;
                    break;
                }
                case 3: {
                    acknowledgeMode = 3;
                    break;
                }
                case 2: {
                    acknowledgeMode = 2;
                }
            }
            log.debug((Object)("Connection is NOT transacted; setting acknowledgeMode to" + this.getAckMode(sessionMode)));
            return this.connection.createSession(false, acknowledgeMode);
        }
        throw new JMSException("No valid JMS connection session");
    }

    private String getAckMode(int ack) {
        switch (ack) {
            case 0: {
                return "SESSION_TRANSACTED";
            }
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
        }
        return "UNKNOWN_ACKNOWLEDGE";
    }

    public Session createSession() throws JMSException {
        if (this.session != null) {
            return this.connection.createSession();
        }
        throw new JMSException("No valid JMS connection session");
    }

    public String getClientID() throws JMSException {
        if (this.session != null) {
            return this.connection.getClientID();
        }
        throw new JMSException("No valid JMS connection session");
    }

    public void setClientID(String clientID) throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS connection session");
        }
        this.connection.setClientID(clientID);
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.session != null) {
            return this.connection.getMetaData();
        }
        throw new JMSException("No valid JMS connection session");
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.session != null) {
            return this.connection.getExceptionListener();
        }
        throw new JMSException("No valid JMS connection session");
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS connection session");
        }
        this.connection.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS connection session");
        }
        this.connection.start();
    }

    public void stop() throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS connection session");
        }
        this.connection.stop();
    }

    @Override
    public void close() throws JMSException {
        if (this.session == null) {
            throw new JMSException("No valid JMS connection session");
        }
        this.connection.close();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.session != null) {
            return this.connection.createConnectionConsumer(destination, messageSelector, sessionPool, maxMessages);
        }
        throw new JMSException("No valid JMS connection session");
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.session != null) {
            return this.connection.createSharedConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
        }
        throw new JMSException("No valid JMS connection session");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.session != null) {
            return this.connection.createDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
        }
        throw new JMSException("No valid JMS connection session");
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.session != null) {
            return this.connection.createSharedDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
        }
        throw new JMSException("No valid JMS connection session");
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        if (this.xaConnection != null && this.xaConnection instanceof XAQueueConnection) {
            return ((XAQueueConnection)this.xaConnection).createXAQueueSession();
        }
        throw new JMSException("JMS connection context does not implement XAQueueConnection");
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.connection != null && this.connection instanceof QueueConnection) {
            return ((QueueConnection)this.connection).createQueueSession(transacted, acknowledgeMode);
        }
        throw new JMSException("JMS connection context does not implement QueueConnection");
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.connection != null && this.connection instanceof QueueConnection) {
            return ((QueueConnection)this.connection).createConnectionConsumer(queue, messageSelector, sessionPool, maxMessages);
        }
        throw new JMSException("JMS connection context does not implement QueueConnection");
    }

    public XATopicSession createXATopicSession() throws JMSException {
        if (this.xaConnection != null && this.xaConnection instanceof XATopicConnection) {
            return ((XATopicConnection)this.xaConnection).createXATopicSession();
        }
        throw new JMSException("JMS connection context does not implement XATopicConnection");
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.connection != null && this.connection instanceof TopicConnection) {
            return ((TopicConnection)this.connection).createTopicSession(transacted, acknowledgeMode);
        }
        throw new JMSException("JMS connection context does not implement TopicConnection");
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this.connection != null && this.connection instanceof TopicConnection) {
            return ((TopicConnection)this.connection).createConnectionConsumer(topic, messageSelector, sessionPool, maxMessages);
        }
        throw new JMSException("JMS connection context does not implement TopicConnection");
    }

    public static class JMSConsumerToTopicSubscriber
    implements TopicSubscriber {
        private final JMSConsumer jmsConsumer;
        private final Topic topic;

        public JMSConsumerToTopicSubscriber(JMSConsumer jmsConsumer, Topic topic) {
            this.jmsConsumer = jmsConsumer;
            this.topic = topic;
        }

        public String getMessageSelector() throws JMSException {
            try {
                return this.jmsConsumer.getMessageSelector();
            }
            catch (JMSRuntimeException jmsre) {
                throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
            }
        }

        public MessageListener getMessageListener() throws JMSException {
            try {
                return this.jmsConsumer.getMessageListener();
            }
            catch (JMSRuntimeException jmsre) {
                throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
            }
        }

        public void setMessageListener(MessageListener listener) throws JMSException {
            try {
                this.jmsConsumer.setMessageListener(listener);
            }
            catch (JMSRuntimeException jmsre) {
                throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
            }
        }

        public Message receive() throws JMSException {
            try {
                return this.jmsConsumer.receive();
            }
            catch (JMSRuntimeException jmsre) {
                throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
            }
        }

        public Message receive(long timeout) throws JMSException {
            try {
                return this.jmsConsumer.receive(timeout);
            }
            catch (JMSRuntimeException jmsre) {
                throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
            }
        }

        public Message receiveNoWait() throws JMSException {
            try {
                return this.jmsConsumer.receiveNoWait();
            }
            catch (JMSRuntimeException jmsre) {
                throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
            }
        }

        public void close() throws JMSException {
            try {
                this.jmsConsumer.close();
            }
            catch (JMSRuntimeException jmsre) {
                throw new JMSException(jmsre.getLocalizedMessage(), jmsre.getErrorCode());
            }
        }

        public Topic getTopic() throws JMSException {
            if (this.topic == null) {
                throw new JMSException("JMSConsumer was configured without a topic");
            }
            return this.topic;
        }

        public boolean getNoLocal() throws JMSException {
            throw new JMSException("JMSConsumer does not support getNoLocal()");
        }
    }
}

