/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.spnego.encoding;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.jboss.security.negotiation.common.DebugHelper;
import org.jboss.security.negotiation.spnego.encoding.NegTokenDecoder;
import org.jboss.security.negotiation.spnego.encoding.NegTokenInit;

public class NegTokenInitDecoder
extends NegTokenDecoder {
    protected static void decodeRequestFlags(InputStream is, NegTokenInit negTokenInit) throws IOException {
        int length = NegTokenDecoder.readLength(is);
        byte[] reqFlags = new byte[length];
        is.read(reqFlags);
        negTokenInit.setReqFlags(reqFlags);
    }

    protected static void decodeMechTypes(InputStream is, NegTokenInit negTokenInit) throws IOException, GSSException {
        int length = NegTokenDecoder.readLength(is);
        byte sequenceType = (byte)is.read();
        int sequenceLength = NegTokenDecoder.readLength(is);
        int leftAfter = is.available() - sequenceLength;
        while (is.available() > leftAfter) {
            negTokenInit.addMechType(new Oid(is));
        }
    }

    protected static void decodeMechToken(InputStream is, NegTokenInit negTokenInit) throws IOException {
        int length = NegTokenDecoder.readLength(is);
        byte type = (byte)is.read();
        int tokenLength = NegTokenInitDecoder.readLength(is);
        byte[] mechToken = new byte[tokenLength];
        is.read(mechToken);
        negTokenInit.setMechToken(mechToken);
    }

    protected static void decodeNegTokenInitSequence(InputStream is, NegTokenInit negTokenInit) throws IOException, GSSException {
        byte type = (byte)is.read();
        int sequenceLength = NegTokenDecoder.readLength(is);
        int leftAfter = is.available() - sequenceLength;
        block6: while (is.available() > leftAfter) {
            byte sequenceType = (byte)is.read();
            switch (sequenceType) {
                case -96: {
                    NegTokenInitDecoder.decodeMechTypes(is, negTokenInit);
                    continue block6;
                }
                case -95: {
                    NegTokenInitDecoder.decodeRequestFlags(is, negTokenInit);
                    continue block6;
                }
                case -94: {
                    NegTokenInitDecoder.decodeMechToken(is, negTokenInit);
                    continue block6;
                }
                case -93: {
                    NegTokenInitDecoder.decodeMechListMIC(is, negTokenInit);
                    continue block6;
                }
            }
            throw new IOException("Unexpected message type" + DebugHelper.convertToHex((byte[])new byte[]{sequenceType}));
        }
    }

    public static NegTokenInit decode(InputStream is) throws IOException, GSSException {
        NegTokenInit negTokenInit = new NegTokenInit();
        byte firstByte = (byte)is.read();
        int totalLength = NegTokenDecoder.readLength(is);
        negTokenInit.setMessageOid(new Oid(is));
        int tokenType = is.read();
        int remainingLength = NegTokenDecoder.readLength(is);
        NegTokenInitDecoder.decodeNegTokenInitSequence(is, negTokenInit);
        return negTokenInit;
    }

    public static NegTokenInit decode(byte[] token) throws IOException, GSSException {
        ByteArrayInputStream bais = new ByteArrayInputStream(token);
        return NegTokenInitDecoder.decode(bais);
    }
}

