/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.Collection;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.DefaultTopologyRunnable;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.CheckTopologyAction;
import org.infinispan.remoting.inboundhandler.action.DefaultReadyAction;
import org.infinispan.remoting.inboundhandler.action.ReadyAction;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.locks.TransactionalRemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TxPerCacheInboundInvocationHandler
extends BasePerCacheInboundInvocationHandler {
    private static final Log log = LogFactory.getLog(TxPerCacheInboundInvocationHandler.class);
    private static final boolean trace = log.isTraceEnabled();
    private final CheckTopologyAction checkTopologyAction = new CheckTopologyAction(this);
    private boolean pessimisticLocking;
    private long lockAcquisitionTimeout;

    @Override
    public void start() {
        super.start();
        this.pessimisticLocking = this.configuration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
        this.lockAcquisitionTimeout = this.configuration.locking().lockAcquisitionTimeout();
    }

    @Override
    public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        try {
            BlockingRunnable runnable;
            int commandTopologyId = TxPerCacheInboundInvocationHandler.extractCommandTopologyId(command);
            boolean onExecutorService = this.executeOnExecutorService(order, command);
            boolean sync = order.preserveOrder();
            boolean waitForTransactionalData = true;
            switch (command.getCommandId()) {
                case 12: 
                case 26: {
                    if (this.pessimisticLocking) {
                        runnable = this.createDefaultRunnable(command, reply, commandTopologyId, true, onExecutorService, sync);
                        break;
                    }
                    runnable = this.createReadyActionRunnable(command, reply, commandTopologyId, onExecutorService, sync, this.createReadyAction(commandTopologyId, (PrepareCommand)command));
                    break;
                }
                case 3: {
                    runnable = this.createReadyActionRunnable(command, reply, commandTopologyId, onExecutorService, sync, this.createReadyAction(commandTopologyId, (LockControlCommand)command));
                    break;
                }
                case 112: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    waitForTransactionalData = false;
                }
                default: {
                    runnable = this.createDefaultRunnable(command, reply, commandTopologyId, waitForTransactionalData, onExecutorService, sync);
                }
            }
            this.handleRunnable(runnable, onExecutorService);
        }
        catch (Throwable throwable) {
            reply.reply(this.exceptionHandlingCommand(command, throwable));
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected boolean isTraceEnabled() {
        return trace;
    }

    private BlockingRunnable createReadyActionRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, boolean onExecutorService, boolean sync, final ReadyAction readyAction) {
        TopologyMode topologyMode = TopologyMode.create(onExecutorService, true);
        if (onExecutorService && readyAction != null) {
            readyAction.addListener(this::checkForReadyTasks);
            return new DefaultTopologyRunnable(this, command, reply, topologyMode, commandTopologyId, sync){

                @Override
                public boolean isReady() {
                    return super.isReady() && readyAction.isReady();
                }
            };
        }
        return new DefaultTopologyRunnable(this, command, reply, topologyMode, commandTopologyId, sync);
    }

    private ReadyAction createReadyAction(int topologyId, TransactionalRemoteLockCommand replicableCommand) {
        if (replicableCommand.hasSkipLocking()) {
            return null;
        }
        Collection<?> keys = replicableCommand.getKeysToLock();
        if (keys.isEmpty()) {
            return null;
        }
        long timeoutMillis = replicableCommand.hasZeroLockAcquisition() ? 0L : this.lockAcquisitionTimeout;
        DefaultReadyAction action = new DefaultReadyAction(new ActionState(replicableCommand, topologyId, timeoutMillis), this.checkTopologyAction);
        action.registerListener();
        return action;
    }
}

