/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.ManagementUtil;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

class AddressControlHandler
extends AbstractRuntimeOnlyHandler {
    static final AddressControlHandler INSTANCE = new AddressControlHandler();

    private AddressControlHandler() {
    }

    protected boolean resourceMustExist(OperationContext context, ModelNode operation) {
        return false;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (ActiveMQActivationService.rollbackOperationIfServerNotActive(context, operation)) {
            return;
        }
        String operationName = operation.require("operation").asString();
        if ("read-attribute".equals(operationName)) {
            this.handleReadAttribute(context, operation);
        }
    }

    private void handleReadAttribute(OperationContext context, ModelNode operation) {
        block10: {
            if (ActiveMQActivationService.ignoreOperationIfServerNotActive(context, operation)) {
                return;
            }
            AddressControl addressControl = this.getAddressControl(context, operation);
            if (addressControl == null) {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(address);
            }
            String name = operation.require("name").asString();
            try {
                if ("roles".equals(name)) {
                    String json = addressControl.getRolesAsJSON();
                    ManagementUtil.reportRoles(context, json);
                    break block10;
                }
                if ("queue-names".equals(name)) {
                    String[] queues = addressControl.getQueueNames();
                    ManagementUtil.reportListOfStrings(context, queues);
                    break block10;
                }
                if ("number-of-bytes-per-page".equals(name)) {
                    long l = addressControl.getNumberOfBytesPerPage();
                    context.getResult().set(l);
                    break block10;
                }
                if ("number-of-pages".equals(name)) {
                    int i = addressControl.getNumberOfPages();
                    context.getResult().set(i);
                    break block10;
                }
                if ("binding-names".equals(name)) {
                    String[] bindings = addressControl.getBindingNames();
                    ManagementUtil.reportListOfStrings(context, bindings);
                    break block10;
                }
                throw MessagingLogger.ROOT_LOGGER.unsupportedAttribute(name);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        }
    }

    private void handleGetRolesAsJson(OperationContext context, ModelNode operation) {
        AddressControl addressControl = this.getAddressControl(context, operation);
        try {
            String json = addressControl.getRolesAsJSON();
            ManagementUtil.reportRolesAsJSON(context, json);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
    }

    private AddressControl getAddressControl(OperationContext context, ModelNode operation) {
        String addressName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController service = context.getServiceRegistry(false).getService(serviceName);
        ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(service.getValue());
        return (AddressControl)AddressControl.class.cast(server.getManagementService().getResource("address." + addressName));
    }
}

