/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.event.logger;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.wildfly.event.logger.AbstractEventLogger;
import org.wildfly.event.logger.Event;
import org.wildfly.event.logger.EventLogger;
import org.wildfly.event.logger.EventWriter;

class AsyncEventLogger
extends AbstractEventLogger
implements EventLogger,
Runnable {
    private volatile int state = 0;
    private static final AtomicIntegerFieldUpdater<AsyncEventLogger> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(AsyncEventLogger.class, "state");
    private final EventWriter writer;
    private final Executor executor;
    private final Deque<Event> pendingMessages;

    AsyncEventLogger(String id, EventWriter writer, Executor executor) {
        super(id);
        this.writer = writer;
        this.executor = executor;
        this.pendingMessages = new ConcurrentLinkedDeque<Event>();
    }

    @Override
    void log(Event event) {
        this.pendingMessages.add(event);
        int state = stateUpdater.get(this);
        if (state == 0 && stateUpdater.compareAndSet(this, 0, 1)) {
            this.executor.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Event event;
        if (!stateUpdater.compareAndSet(this, 1, 2)) {
            return;
        }
        ArrayList<Event> events = new ArrayList<Event>();
        for (int i = 0; i < 1000 && (event = this.pendingMessages.poll()) != null; ++i) {
            events.add(event);
        }
        try {
            if (!events.isEmpty()) {
                this.writeMessage(events);
            }
        }
        finally {
            stateUpdater.set(this, 0);
            if (!events.isEmpty() && stateUpdater.compareAndSet(this, 0, 1)) {
                this.executor.execute(this);
            }
        }
    }

    private void writeMessage(List<Event> events) {
        for (Event event : events) {
            this.writer.write(event);
        }
    }
}

