/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl._private;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.wildfly.security.mechanism.AuthenticationMechanismException;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=1157, max=1157), @ValidIdRange(min=5001, max=5163)})
public interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");
    public static final ElytronMessages sasl = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security.sasl");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1157, value="Unable to resolve MechanismConfiguration for MechanismInformation")
    public void unableToResolveMechanismConfiguration(@Cause Throwable var1);

    @Message(id=5001, value="Authentication mechanism exchange received a message after authentication was already complete")
    public AuthenticationMechanismException mechMessageAfterComplete();

    @Message(id=5005, value="Authentication mechanism authentication is not yet complete")
    public IllegalStateException mechAuthenticationNotComplete();

    @Message(id=5015, value="Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorUnexpectedChar(int var1, long var2, String var4);

    @Message(id=5017, value="Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorTokenNotAllowed(String var1, long var2, String var4);

    @Message(id=5020, value="Unexpected end of mechanism selection string \"%s\"")
    public IllegalArgumentException mechSelectorUnexpectedEnd(String var1);

    @Message(id=5058, value="Authentication failed")
    public AuthenticationMechanismException mechAuthenticationFailed();

    @Message(id=5090, value="Wrapping is not configured")
    public IllegalStateException wrappingNotConfigured();

    @Message(id=5130, value="Invalid non-ASCII space \"0x%X\"")
    public IllegalArgumentException invalidNonAsciiSpace(int var1);

    @Message(id=5053, value="Callback handler failed for unknown reason")
    public AuthenticationMechanismException mechCallbackHandlerFailedForUnknownReason(@Cause Throwable var1);

    @Message(id=5131, value="Invalid ASCII control \"0x%X\"")
    public IllegalArgumentException invalidAsciiControl(int var1);

    @Message(id=5132, value="Invalid non-ASCII control \"0x%X\"")
    public IllegalArgumentException invalidNonAsciiControl(int var1);

    @Message(id=5133, value="Invalid private use character \"0x%X\"")
    public IllegalArgumentException invalidPrivateUseCharacter(int var1);

    @Message(id=5134, value="Invalid non-character code point \"0x%X\"")
    public IllegalArgumentException invalidNonCharacterCodePoint(int var1);

    @Message(id=5135, value="Invalid surrogate code point \"0x%X\"")
    public IllegalArgumentException invalidSurrogateCodePoint(int var1);

    @Message(id=5136, value="Invalid plain text code point \"0x%X\"")
    public IllegalArgumentException invalidPlainTextCodePoint(int var1);

    @Message(id=5137, value="Invalid non-canonical code point \"0x%X\"")
    public IllegalArgumentException invalidNonCanonicalCodePoint(int var1);

    @Message(id=5138, value="Invalid control character \"0x%X\"")
    public IllegalArgumentException invalidControlCharacter(int var1);

    @Message(id=5139, value="Invalid tagging character \"0x%X\"")
    public IllegalArgumentException invalidTaggingCharacter(int var1);

    @Message(id=5140, value="Unassigned code point \"0x%X\"")
    public IllegalArgumentException unassignedCodePoint(int var1);

    @Message(id=5141, value="Invalid surrogate pair (high at end of string) \"0x%X\"")
    public IllegalArgumentException invalidSurrogatePairHightAtEnd(char var1);

    @Message(id=5142, value="Invalid surrogate pair (second is not low) \"0x%X 0x%X\"")
    public IllegalArgumentException invalidSurrogatePairSecondIsNotLow(char var1, char var2);

    @Message(id=5143, value="Invalid surrogate pair (low without high) \"0x%X\"")
    public IllegalArgumentException invalidSurrogatePairLowWithoutHigh(char var1);

    @Message(id=5144, value="Invalid code point \"0x%X\"")
    public IllegalArgumentException invalidCodePoint(int var1);

    @Message(id=5145, value="Disallowed R/AL directionality character in L string")
    public IllegalArgumentException disallowedRalDirectionalityInL();

    @Message(id=5146, value="Disallowed L directionality character in R/AL string")
    public IllegalArgumentException disallowedLDirectionalityInRal();

    @Message(id=5147, value="Missing trailing R/AL directionality character")
    public IllegalArgumentException missingTrailingRal();

    @Message(id=5148, value="Invalid escape sequence")
    public IllegalArgumentException invalidEscapeSequence();

    @Message(id=5163, value="Authentication mechanism server timed out")
    public AuthenticationMechanismException mechServerTimedOut();
}

