/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.EnumSet;
import org.jboss.as.clustering.controller.IdentityCapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.UnaryServiceNameFactory;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.web.WebProviderRequirement;
import org.wildfly.extension.clustering.web.DistributableWebResourceDefinition;

public class DistributableWebResourceServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ServiceTarget target = context.getServiceTarget();
        String defaultSessionManagement = DistributableWebResourceDefinition.Attribute.DEFAULT_SESSION_MANAGEMENT.resolveModelAttribute((ExpressionResolver)context, model).asString();
        new IdentityCapabilityServiceConfigurator(DistributableWebResourceDefinition.Capability.DEFAULT_SESSION_MANAGEMENT_PROVIDER.getServiceName(address), (UnaryServiceNameFactory)WebProviderRequirement.SESSION_MANAGEMENT_PROVIDER, defaultSessionManagement).configure(context).build(target).install();
        String defaultSSOManagement = DistributableWebResourceDefinition.Attribute.DEFAULT_SSO_MANAGEMENT.resolveModelAttribute((ExpressionResolver)context, model).asString();
        new IdentityCapabilityServiceConfigurator(DistributableWebResourceDefinition.Capability.DEFAULT_SSO_MANAGEMENT_PROVIDER.getServiceName(address), (UnaryServiceNameFactory)WebProviderRequirement.SSO_MANAGEMENT_PROVIDER, defaultSSOManagement).configure(context).build(target).install();
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        for (DistributableWebResourceDefinition.Capability capability : EnumSet.allOf(DistributableWebResourceDefinition.Capability.class)) {
            context.removeService(capability.getServiceName(address));
        }
    }
}

