/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.interfaces.AbstractInterfaceCriteria;
import org.jboss.as.controller.interfaces.InetAddressMatchInterfaceCriteria;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.wildfly.common.Assert;

public class AnyInterfaceCriteria
implements InterfaceCriteria {
    private static final long serialVersionUID = 3384500068401101329L;
    private final Set<InterfaceCriteria> criteria = new LinkedHashSet<InterfaceCriteria>();

    public AnyInterfaceCriteria(Set<InterfaceCriteria> criteria) {
        Assert.checkNotNullParam((String)"criteria", criteria);
        this.criteria.addAll(criteria);
    }

    @Override
    public Map<NetworkInterface, Set<InetAddress>> getAcceptableAddresses(Map<NetworkInterface, Set<InetAddress>> candidates) throws SocketException {
        HashMap<NetworkInterface, Set<InetAddress>> result = new HashMap<NetworkInterface, Set<InetAddress>>();
        for (InterfaceCriteria ic : this.criteria) {
            Map<NetworkInterface, Set<InetAddress>> testee = AbstractInterfaceCriteria.cloneCandidates(candidates);
            Map<NetworkInterface, Set<InetAddress>> accepted = ic.getAcceptableAddresses(testee);
            this.addAccepted(accepted, result);
        }
        return result;
    }

    public int hashCode() {
        return this.criteria.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnyInterfaceCriteria)) {
            return false;
        }
        return this.criteria.equals(((AnyInterfaceCriteria)o).criteria);
    }

    @Override
    public int compareTo(InterfaceCriteria o) {
        if (this.equals(o)) {
            return 0;
        }
        return o instanceof InetAddressMatchInterfaceCriteria ? -1 : 1;
    }

    private void addAccepted(Map<NetworkInterface, Set<InetAddress>> accepted, Map<NetworkInterface, Set<InetAddress>> result) {
        for (Map.Entry<NetworkInterface, Set<InetAddress>> entry : accepted.entrySet()) {
            Set<InetAddress> addresses = result.get(entry.getKey());
            if (addresses == null) {
                result.put(entry.getKey(), new HashSet(entry.getValue()));
                continue;
            }
            addresses.addAll((Collection<InetAddress>)entry.getValue());
        }
    }
}

