/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.logging;

import java.io.IOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.URI;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.remoting3.Channel;

@MessageLogger(projectCode="WFLYPRT", length=4)
public interface ProtocolLogger
extends BasicLogger {
    public static final ProtocolLogger ROOT_LOGGER = Logger.getMessageLogger(ProtocolLogger.class, "org.jboss.as.protocol");
    public static final ProtocolLogger CONNECTION_LOGGER = Logger.getMessageLogger(ProtocolLogger.class, "org.jboss.as.protocol.connection");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="Got error closing channel %s")
    public void errorClosingChannel(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="Failed to close resource %s")
    public void failedToCloseResource(@Cause Throwable var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="Failed to close the server socket %s")
    public void failedToCloseServerSocket(@Cause Throwable var1, ServerSocket var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18, value="No such request (%d) associated with channel %s")
    public void noSuchRequest(int var1, Channel var2);

    @Message(id=23, value="Could not connect to %s. The connection timed out")
    public ConnectException couldNotConnect(URI var1);

    @Message(id=30, value="Invalid byte token.  Expecting '%d' received '%d'")
    public IOException invalidByteToken(int var1, byte var2);

    @Message(id=32, value="Invalid signature [%s]")
    public IOException invalidSignature(String var1);

    @Message(id=34, value="Invalid type: %s")
    public IOException invalidType(String var1);

    @Message(id=35, value="Type is neither %s or %s: %s")
    public IllegalArgumentException invalidType(String var1, String var2, byte var3);

    @Message(id=51, value="Operation with id %d already registered")
    public IllegalStateException operationIdAlreadyExists(int var1);

    @Message(id=52, value="Null executor")
    public IllegalArgumentException nullExecutor();

    @Message(id=53, value="Could not connect to %s. The connection failed")
    public ConnectException failedToConnect(URI var1, @Cause Exception var2);

    @Message(id=54, value="Channel closed")
    public IOException channelClosed();

    @Message(id=55, value="no handler registered for request type '%s'.")
    public IOException noSuchResponseHandler(String var1);

    @Message(id=56, value="No response handler for request %s")
    public IOException responseHandlerNotFound(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=57, value="%s cancelled task by interrupting thread %s")
    public void cancelledAsyncTask(String var1, Thread var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=58, value="%s cancelled task before execution began")
    public void cancelledAsyncTaskBeforeRun(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=59, value="You are using a deprecated way to set the client bind address. Please use the \"--bind\" parameter on the CLI instead of the %s system property.")
    public void deprecatedCLIConfiguration(String var1);

    @Message(id=60, value="Channel open request timed out")
    public IOException channelTimedOut();
}

