/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryAwareLocalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RecoveryAwareTransactionTable
extends XaTransactionTable {
    private static final Log log = LogFactory.getLog(RecoveryAwareTransactionTable.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    public void remoteTransactionPrepared(GlobalTransaction gtx) {
        RecoveryAwareRemoteTransaction remoteTransaction = (RecoveryAwareRemoteTransaction)this.getRemoteTransaction(gtx);
        if (remoteTransaction == null) {
            throw new CacheException(String.format("Remote transaction for global transaction (%s) not found", gtx));
        }
        remoteTransaction.setPrepared(true);
    }

    @Override
    public void localTransactionPrepared(LocalTransaction localTransaction) {
        ((RecoveryAwareLocalTransaction)localTransaction).setPrepared(true);
    }

    @Override
    public void cleanupLeaverTransactions(List<Address> members) {
        Iterator<RemoteTransaction> it = this.getRemoteTransactions().iterator();
        HashSet<Address> membersSet = new HashSet<Address>(members);
        while (it.hasNext()) {
            RecoveryAwareRemoteTransaction recTx = (RecoveryAwareRemoteTransaction)it.next();
            if (!this.transactionOriginatorChecker.isOriginatorMissing(recTx.getGlobalTransaction(), membersSet)) continue;
            recTx.computeOrphan(membersSet);
            if (!recTx.isInDoubt()) continue;
            this.recoveryManager.registerInDoubtTransaction(recTx);
            it.remove();
        }
        super.cleanupLeaverTransactions(members);
    }

    @Override
    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        RemoteTransaction remoteTransaction = super.getRemoteTransaction(txId);
        if (remoteTransaction != null) {
            return remoteTransaction;
        }
        return (RemoteTransaction)((Object)this.recoveryManager.getPreparedTransaction(txId.getXid()));
    }

    @Override
    public void remoteTransactionRollback(GlobalTransaction gtx) {
        super.remoteTransactionRollback(gtx);
        this.recoveryManager.removeRecoveryInformation(gtx.getXid());
    }

    @Override
    public void remoteTransactionCommitted(GlobalTransaction gtx, boolean onePc) {
        RecoveryAwareRemoteTransaction remoteTransaction = (RecoveryAwareRemoteTransaction)this.getRemoteTransaction(gtx);
        if (remoteTransaction == null) {
            throw new CacheException(String.format("Remote transaction for global transaction (%s) not found", gtx));
        }
        remoteTransaction.markCompleted(true);
        super.remoteTransactionCommitted(gtx, onePc);
    }

    public List<XidImpl> getLocalPreparedXids() {
        LinkedList<XidImpl> result = new LinkedList<XidImpl>();
        for (Map.Entry e : this.xid2LocalTx.entrySet()) {
            RecoveryAwareLocalTransaction value = (RecoveryAwareLocalTransaction)e.getValue();
            if (!value.isPrepared()) continue;
            result.add((XidImpl)e.getKey());
        }
        return result;
    }

    @Override
    public void failureCompletingTransaction(Transaction tx) {
        RecoveryAwareLocalTransaction localTx = (RecoveryAwareLocalTransaction)this.getLocalTransaction(tx);
        if (localTx == null) {
            throw new CacheException(String.format("Local transaction for transaction (%s) not found", tx));
        }
        localTx.setCompletionFailed(true);
        log.tracef("Marked as completion failed %s", localTx);
    }

    public Set<RecoveryAwareLocalTransaction> getLocalTxThatFailedToComplete() {
        HashSet<RecoveryAwareLocalTransaction> result = new HashSet<RecoveryAwareLocalTransaction>(4);
        for (LocalTransaction lTx : this.xid2LocalTx.values()) {
            RecoveryAwareLocalTransaction lTx1 = (RecoveryAwareLocalTransaction)lTx;
            if (!lTx1.isCompletionFailed()) continue;
            result.add(lTx1);
        }
        return result;
    }

    public XidImpl getRemoteTransactionXid(Long internalId) {
        for (RemoteTransaction rTx : this.getRemoteTransactions()) {
            GlobalTransaction gtx = rTx.getGlobalTransaction();
            if (gtx.getInternalId() != internalId.longValue()) continue;
            if (trace) {
                log.tracef("Found xid %s matching internal id %s", gtx.getXid(), internalId);
            }
            return gtx.getXid();
        }
        if (trace) {
            log.tracef("Could not find remote transactions matching internal id %s", internalId);
        }
        return null;
    }

    public RemoteTransaction removeRemoteTransaction(XidImpl xid) {
        if (this.clustered) {
            Iterator<RemoteTransaction> it = this.getRemoteTransactions().iterator();
            while (it.hasNext()) {
                RemoteTransaction next = it.next();
                GlobalTransaction gtx = next.getGlobalTransaction();
                if (!xid.equals((Object)gtx.getXid())) continue;
                it.remove();
                this.recalculateMinTopologyIdIfNeeded(next);
                next.notifyOnTransactionFinished();
                return next;
            }
        }
        return null;
    }
}

